/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamPvpSubCommand {
    private final UltimateTeams plugin;

    public TeamPvpSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamPvpSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().isPvpCommandEnabled()) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.PVP))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (team.isFriendlyFireAllowed()) {
                team.setFriendlyFire(false);
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getDisabledFriendlyFire(), new String[0]));
            } else {
                team.setFriendlyFire(true);
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getEnabledFriendlyFire(), new String[0]));
            }
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedNotInTeam(), new String[0])));
    }
}

