/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamTransferOwnershipEvent;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Values;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamTransferOwnerSubCommand {
    private final UltimateTeams plugin;

    public TeamTransferOwnerSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void transferTeamOwnerSubCommand(CommandSender sender, @Values(value="teamPlayers") String memberName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        String PLAYER_PLACEHOLDER = "%PLAYER%";
        OfflinePlayer newTeamOwner = Bukkit.getOfflinePlayer((String)memberName);
        if (!this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamMustBeOwner(), new String[0]));
            return;
        }
        if (newTeamOwner.getName() == null) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerNotFound(), new String[0]));
            return;
        }
        if (player.getUniqueId().equals(newTeamOwner.getUniqueId())) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamOwnershipTransferFailedCannotTransferToSelf().replace("%PLAYER%", player.getName()), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByOwner(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!team.getMembers().containsKey(newTeamOwner.getUniqueId())) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamOwnershipTransferFailureNotSameTeam(), new String[0]));
                return;
            }
            if (new TeamTransferOwnershipEvent(team.getOwner(), player.getUniqueId(), (Team)team).callEvent()) {
                return;
            }
            this.plugin.getTeamStorageUtil().transferTeamOwner((Team)team, newTeamOwner.getUniqueId());
            String OLD_OWNER_PLACEHOLDER = "%OLDOWNER%";
            String NEW_Team_NAME = "%Team%";
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamOwnershipTransferSuccessful().replace("%PLAYER%", newTeamOwner.getName()), new String[0]));
            if (newTeamOwner.isOnline() && newTeamOwner.getPlayer() != null) {
                newTeamOwner.getPlayer().sendMessage(MineDown.parse(this.plugin.getMessages().getTeamOwnershipTransferNewOwner().replace(OLD_OWNER_PLACEHOLDER, player.getName()).replace(NEW_Team_NAME, team.getName()), new String[0]));
            }
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedNotInTeam(), new String[0])));
    }
}

