/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.relations;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamAllyAddEvent;
import dev.xf3d3.ultimateteams.api.events.TeamAllyRemoveEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import java.util.Optional;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamAllySubCommand {
    private final Logger logger;
    private static final String ALLY_TEAM = "%ALLYTEAM%";
    private static final String ALLY_OWNER = "%ALLYTEAM%";
    private static final String TEAM_OWNER = "%TEAMOWNER%";
    private final UltimateTeams plugin;

    public TeamAllySubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public void teamAllyAddSubCommand(CommandSender sender, String teamName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RELATIONS))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (team.getRelations(this.plugin).size() >= this.plugin.getSettings().getMaxTeamAllies()) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamAllyMaxAmountReached().replaceAll("%LIMIT%", String.valueOf(this.plugin.getSettings().getMaxTeamAllies())), new String[0]));
                return;
            }
            Optional<Team> optionalOtherTeam = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
            if (optionalOtherTeam.isEmpty() || optionalOtherTeam.get().equals(team)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNotFound(), new String[0]));
                return;
            }
            Team otherTeam = optionalOtherTeam.get();
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ENEMY)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedCannotAllyEnemyTeam(), new String[0]));
                return;
            }
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ALLY)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedTeamAlreadyYourAlly(), new String[0]));
                return;
            }
            if (new TeamAllyAddEvent(player, (Team)team, otherTeam, otherTeam.getOwner()).callEvent()) {
                return;
            }
            this.plugin.getTeamStorageUtil().addTeamAlly((Team)team, otherTeam, player);
            team.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getAddedTeamToYourAllies().replaceAll("%ALLYTEAM%", otherTeam.getName()), new String[0]));
            otherTeam.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getTeamAddedToOtherAllies().replaceAll(TEAM_OWNER, team.getName()), new String[0]));
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedNotInTeam(), new String[0])));
    }

    public void teamAllyRemoveSubCommand(CommandSender sender, String teamName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RELATIONS))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            Optional<Team> optionalOtherTeam = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
            if (optionalOtherTeam.isEmpty() || optionalOtherTeam.get().equals(team)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNotFound(), new String[0]));
                return;
            }
            Team otherTeam = optionalOtherTeam.get();
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ALLY)) {
                if (new TeamAllyRemoveEvent(player, (Team)team, otherTeam, otherTeam.getOwner()).callEvent()) {
                    return;
                }
                this.plugin.getTeamStorageUtil().removeTeamAlly((Team)team, otherTeam, player);
                team.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getRemovedTeamFromYourAllies().replace("%ALLYTEAM%", otherTeam.getName()), new String[0]));
                otherTeam.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getTeamRemovedFromOtherAllies().replace("%ALLYTEAM%", team.getName()), new String[0]));
            } else {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedToRemoveTeamFromAllies().replace("%ALLYTEAM%", teamName), new String[0]));
            }
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

