/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.relations;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamEnemyAddEvent;
import dev.xf3d3.ultimateteams.api.events.TeamEnemyRemoveEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamEnemySubCommand {
    private static final String ENEMY_Team = "%ENEMYTEAM%";
    private final UltimateTeams plugin;

    public TeamEnemySubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamEnemySubAddCommand(CommandSender sender, String teamName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RELATIONS))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (team.getRelations(this.plugin).size() >= this.plugin.getSettings().getMaxTeamEnemies()) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamEnemyMaxAmountReached().replaceAll("%LIMIT%", String.valueOf(this.plugin.getSettings().getMaxTeamAllies())), new String[0]));
                return;
            }
            Optional<Team> optionalOtherTeam = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
            if (optionalOtherTeam.isEmpty() || optionalOtherTeam.get().equals(team)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNotFound(), new String[0]));
                return;
            }
            Team otherTeam = optionalOtherTeam.get();
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ALLY)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedCannotEnemyAlliedTeam(), new String[0]));
                return;
            }
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ENEMY)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedTeamAlreadyYourEnemy(), new String[0]));
                return;
            }
            if (new TeamEnemyAddEvent(player, (Team)team, otherTeam, otherTeam.getOwner()).callEvent()) {
                return;
            }
            this.plugin.getTeamStorageUtil().addTeamEnemy((Team)team, otherTeam, player);
            team.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getAddedTeamToYourEnemies().replaceAll(ENEMY_Team, otherTeam.getName()), new String[0]));
            otherTeam.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getTeamAddedToOtherEnemies().replaceAll("%TEAMOWNER%", team.getName()), new String[0]));
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }

    public void teamEnemySubRemoveCommand(CommandSender sender, String teamName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RELATIONS))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            Optional<Team> optionalOtherTeam = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
            if (optionalOtherTeam.isEmpty() || optionalOtherTeam.get().equals(team)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNotFound(), new String[0]));
                return;
            }
            Team otherTeam = optionalOtherTeam.get();
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ENEMY)) {
                if (new TeamEnemyRemoveEvent(player, (Team)team, otherTeam, otherTeam.getOwner()).callEvent()) {
                    return;
                }
                this.plugin.getTeamStorageUtil().removeTeamEnemy((Team)team, otherTeam, player);
                team.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getRemovedTeamFromYourEnemies().replace(ENEMY_Team, otherTeam.getName()), new String[0]));
                otherTeam.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getTeamRemovedFromOtherEnemies().replace("%TEAMOWNER%", team.getName()), new String[0]));
            } else {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedToRemoveTeamFromEnemies().replace(ENEMY_Team, teamName), new String[0]));
            }
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

