/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.warps;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamWarpSetEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamWarp;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamSetWarpSubCommand {
    private final UltimateTeams plugin;

    public TeamSetWarpSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void setWarpCommand(CommandSender sender, String name) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamWarpEnabled()) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        if (name.contains(" ")) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getIncorrectCommandUsage(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.WARPS))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAccept(teamPlayer -> {
                if (team.getWarps().size() >= teamPlayer.getMaxWarps(player, this.plugin.getSettings().getTeamWarpLimit(), this.plugin.getSettings().getTeamWarpStackEnabled())) {
                    player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamWarpLimitReached(), new String[0]));
                    return;
                }
                if (team.getTeamWarp(name).isPresent()) {
                    player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamWarpNameUsed(), new String[0]));
                    return;
                }
                TeamWarp warp = TeamWarp.of(name, player.getLocation(), this.plugin.getSettings().getServerName());
                if (new TeamWarpSetEvent(player, (Team)team, warp).callEvent()) {
                    return;
                }
                team.addTeamWarp(warp);
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamWarpSuccessful().replaceAll("%WARP_NAME%", warp.getName()), new String[0]));
            });
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

