/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.warps;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamTeleportEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamWarp;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamWarpSubCommand {
    private final UltimateTeams plugin;
    private static final ConcurrentHashMap<UUID, Long> warpCoolDownTimer = new ConcurrentHashMap();
    private static final String TIME_LEFT = "%TIMELEFT%";

    public TeamWarpSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void WarpCommand(CommandSender sender, String name) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamWarpEnabled()) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!this.plugin.getSettings().teamWarpCooldownEnabled()) {
                this.tpWarp(player, (Team)team, name);
                return;
            }
            if (!player.hasPermission("ultimateteams.bypass.warpcooldown") && warpCoolDownTimer.containsKey(player.getUniqueId())) {
                if (warpCoolDownTimer.get(player.getUniqueId()) > System.currentTimeMillis()) {
                    long timeLeft = (warpCoolDownTimer.get(player.getUniqueId()) - System.currentTimeMillis()) / 1000L;
                    player.sendMessage(MineDown.parse(this.plugin.getMessages().getHomeCoolDownTimerWait().replaceAll(TIME_LEFT, Long.toString(timeLeft)), new String[0]));
                } else {
                    warpCoolDownTimer.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.plugin.getSettings().getTeamHomeCooldownValue() * 1000L);
                    this.tpWarp(player, (Team)team, name);
                }
            } else {
                this.tpWarp(player, (Team)team, name);
                warpCoolDownTimer.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.plugin.getSettings().getTeamHomeCooldownValue() * 1000L);
            }
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }

    private void tpWarp(Player player, Team team, String name) {
        team.getTeamWarp(name).ifPresentOrElse(warp -> {
            if (new TeamTeleportEvent(player, team, warp.getLocation()).callEvent()) {
                return;
            }
            this.plugin.getUtils().teleportPlayer(player, warp.getLocation(), warp.getServer(), Utils.TeleportType.WARP, name);
            MineDown.parse(this.plugin.getMessages().getTeamWarpTeleportedSuccessful().replaceAll("%WARP_NAME%", warp.getName()), new String[0]);
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamWarpNotFound(), new String[0])));
    }

    public void showWarpsMenu(@NotNull CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamWarpEnabled()) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (team.getWarps().isEmpty()) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamWarpEmpty(), new String[0]));
                return;
            }
            player.sendMessage(MineDown.parse(String.join((CharSequence)"\n", this.plugin.getMessages().getTeamWarpMenuHeader()).replaceAll("%TEAM%", team.getName()), new String[0]));
            for (TeamWarp warp : team.getWarps().values()) {
                String warpInfo = String.join((CharSequence)"\n", this.plugin.getMessages().getTeamWarpMenuItemInfo()).replaceAll("%WARP_NAME%", warp.getName()).replaceAll("%X%", String.valueOf((int)warp.getWarpX())).replaceAll("%Y%", String.valueOf((int)warp.getWarpY())).replaceAll("%Z%", String.valueOf((int)warp.getWarpZ())).replaceAll("%WORLD_NAME%", warp.getWarpWorld()).replaceAll("%SERVER_NAME%", Objects.requireNonNullElse(warp.getServer(), this.plugin.getSettings().getServerName()));
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamWarpMenuItem().replaceAll("%WARP_NAME%", warp.getName()).replaceAll("%WARP_INFO%", warpInfo), new String[0]));
            }
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

