/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.database;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.database.Database;
import dev.xf3d3.ultimateteams.libraries.gson.JsonSyntaxException;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.sqlite.SQLiteConfig;

public class SQLiteDatabase
extends Database {
    private static final String DATABASE_FILE_NAME = "UltimateTeamsData.db";
    private final File databaseFile;
    private Connection connection;

    public SQLiteDatabase(@NotNull UltimateTeams plugin) {
        super(plugin);
        this.databaseFile = new File(plugin.getDataFolder(), DATABASE_FILE_NAME);
    }

    private Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.setConnection();
        } else if (this.connection.isClosed()) {
            this.setConnection();
        }
        return this.connection;
    }

    private void setConnection() {
        try {
            if (this.databaseFile.createNewFile()) {
                this.plugin.log(Level.INFO, "Created the SQLite database file", new Throwable[0]);
            }
            Class.forName("org.sqlite.JDBC");
            SQLiteConfig config = new SQLiteConfig();
            config.enforceForeignKeys(true);
            config.setEncoding(SQLiteConfig.Encoding.UTF8);
            config.setJournalMode(SQLiteConfig.JournalMode.WAL);
            config.setSynchronous(SQLiteConfig.SynchronousMode.FULL);
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.databaseFile.getAbsolutePath(), config.toProperties());
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "An exception occurred creating the database file", e);
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "An SQL exception occurred initializing the SQLite database", e);
        }
        catch (ClassNotFoundException e) {
            this.plugin.log(Level.SEVERE, "Failed to load the necessary SQLite driver", e);
        }
    }

    @Override
    public void initialize() {
        this.setConnection();
        try (Statement statement = this.getConnection().createStatement();){
            for (String tableCreationStatement : this.getSchema("database/sqlite_schema.sql")) {
                statement.execute(tableCreationStatement);
            }
            this.setLoaded(true);
        }
        catch (IOException | SQLException e) {
            this.setLoaded(false);
            throw new IllegalStateException("Failed to create SQLite database tables.", e);
        }
        this.plugin.getLogger().info("Database tables created");
    }

    @Override
    public List<Team> getAllTeams() {
        ArrayList<Team> teams = new ArrayList<Team>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("SELECT `id`, `data`\nFROM `%team_table%`\n"));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String data = new String(resultSet.getBytes("data"), StandardCharsets.UTF_8);
                Team team = this.plugin.getGson().fromJson(data, Team.class);
                if (team == null) continue;
                team.setId(resultSet.getInt("id"));
                teams.add(team);
            }
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to fetch list of teams from table", e);
        }
        return teams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Team> getTeam(@NotNull Integer id) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("SELECT *\nFROM `%team_table%`\nWHERE `id` = ?\n"));){
            statement.setInt(1, id);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            String data = new String(resultSet.getBytes("data"), StandardCharsets.UTF_8);
            Team team = this.plugin.getGson().fromJson(data, Team.class);
            if (team == null) return Optional.empty();
            team.setId(resultSet.getInt("id"));
            Optional<Team> optional = Optional.of(team);
            return optional;
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update team in table", e);
        }
        return Optional.empty();
    }

    @Override
    public void createPlayer(@NotNull TeamPlayer teamplayer) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("INSERT INTO `%user_table%` (`uuid`, `username`, `isBedrock`, `bedrockUUID`, `preferences`)\nVALUES (?, ?, ?, ?, ?)\n"));){
            statement.setString(1, String.valueOf(teamplayer.getJavaUUID()));
            statement.setString(2, teamplayer.getLastPlayerName());
            statement.setBoolean(3, teamplayer.isBedrockPlayer());
            statement.setString(4, teamplayer.getBedrockUUID());
            statement.setBytes(5, this.plugin.getGson().toJson(teamplayer.getPreferences()).getBytes(StandardCharsets.UTF_8));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to create player in table", e);
        }
    }

    @Override
    public void updatePlayer(@NotNull TeamPlayer teamplayer) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("UPDATE `%user_table%`\nSET `username` = ?, `isBedrock` = ?, `bedrockUUID` = ?, `preferences` = ?\nWHERE `uuid` = ?\n"));){
            statement.setString(1, teamplayer.getLastPlayerName());
            statement.setBoolean(2, teamplayer.isBedrockPlayer());
            statement.setString(3, teamplayer.getBedrockUUID());
            statement.setBytes(4, this.plugin.getGson().toJson(teamplayer.getPreferences()).getBytes(StandardCharsets.UTF_8));
            statement.setString(5, String.valueOf(teamplayer.getJavaUUID()));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update player in table", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<TeamPlayer> getPlayer(@NotNull UUID uuid) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("SELECT *\nFROM `%user_table%`\nWHERE `uuid` = ?\n"));){
            statement.setString(1, String.valueOf(uuid));
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            TeamPlayer teamPlayer = new TeamPlayer(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username"), resultSet.getBoolean("isBedrock"), resultSet.getString("bedrockUUID"), this.plugin.getPreferencesFromJson(new String(resultSet.getBytes("preferences"), StandardCharsets.UTF_8)));
            Optional<TeamPlayer> optional = Optional.of(teamPlayer);
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to get player from table", e);
        }
        return Optional.empty();
    }

    @Override
    public void deleteAllUsers() {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("DELETE FROM `%user_table%`"));){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete all users from table", e);
        }
    }

    @Override
    public Team createTeam(@NotNull String name, @NotNull Player creator) {
        Team team = Team.create(name, creator, this.plugin.getSettings().isPvpDefaultAllow(), this.plugin.getSettings().getTeamEnderChestRows());
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("INSERT INTO `%team_table%` (`name`, `data`)\nVALUES (?, ?)\n"), 1);){
            statement.setString(1, team.getName());
            statement.setBytes(2, this.plugin.getGson().toJson(team).getBytes(StandardCharsets.UTF_8));
            statement.executeUpdate();
            ResultSet insertedRow = statement.getGeneratedKeys();
            if (insertedRow.next()) {
                team.setId(insertedRow.getInt(1));
            }
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to create team in table", e);
        }
        return team;
    }

    @Override
    public Team createTeam(@NotNull Team team) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("INSERT INTO `%team_table%` (`name`, `data`)\nVALUES (?, ?)\n"), 1);){
            statement.setString(1, team.getName());
            statement.setBytes(2, this.plugin.getGson().toJson(team).getBytes(StandardCharsets.UTF_8));
            statement.executeUpdate();
            ResultSet insertedRow = statement.getGeneratedKeys();
            if (insertedRow.next()) {
                team.setId(insertedRow.getInt(1));
            }
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to create migrated team in table", e);
        }
        return team;
    }

    @Override
    public void updateTeam(@NotNull Team team) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("UPDATE `%team_table%`\nSET `name` = ?, `data` = ?\nWHERE `id` = ?\n"));){
            statement.setString(1, team.getName());
            statement.setBytes(2, this.plugin.getGson().toJson(team).getBytes(StandardCharsets.UTF_8));
            statement.setInt(3, team.getId());
            statement.executeUpdate();
            statement.clearParameters();
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update team in table", e);
        }
    }

    @Override
    public void deleteTeam(@NotNull Integer id) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("DELETE FROM `%team_table%`\nWHERE `id` = ?\n"));){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete team in table", e);
        }
    }

    @Override
    public void deleteAllTeams() {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("DELETE FROM %team_table%"));){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete all teams from table", e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to close connection", e);
        }
    }
}

