/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.gui;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.gui.TeamList;
import dev.xf3d3.ultimateteams.gui.TeamManager;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.DynamicGuiElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiElementGroup;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiPageElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.InventoryGui;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AlliesManager {
    private final UltimateTeams plugin;
    private final Player player;

    public AlliesManager(@NotNull UltimateTeams plugin, @NotNull Player player) {
        this.plugin = plugin;
        this.player = player;
        this.open();
    }

    private void open() {
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, (InventoryHolder)this.player, Utils.Color(this.plugin.getTeamsGui().getAlliesManagerGuiName()), this.plugin.getTeamsGui().getTeamsManagerAlliesguiSetup().toArray(new String[0]), new GuiElement[0]);
        gui.addElement(new GuiPageElement('f', new ItemStack(this.plugin.getTeamsGui().getPreviousPageMaterial()), GuiPageElement.PageAction.PREVIOUS, this.plugin.getTeamsGui().getPreviousPage()));
        gui.addElement(new GuiPageElement('n', new ItemStack(this.plugin.getTeamsGui().getNextPageMaterial()), GuiPageElement.PageAction.NEXT, this.plugin.getTeamsGui().getNextPage()));
        gui.addElement(new StaticGuiElement('b', new ItemStack(this.plugin.getTeamsGui().getBackButtonMaterial()), 1, click -> {
            click.getGui().close();
            new TeamManager(this.plugin, this.player);
            return true;
        }, this.plugin.getTeamsGui().getBackButtonName()));
        GuiElementGroup group = new GuiElementGroup('g', new GuiElement[0]);
        Optional<Team> OptionalTeam = this.plugin.getTeamStorageUtil().findTeamByMember(this.player.getUniqueId());
        if (OptionalTeam.isEmpty()) {
            throw new IllegalStateException("Team not found");
        }
        Team team = OptionalTeam.get();
        Set allies = team.getRelations(this.plugin).entrySet().stream().filter(entry -> entry.getValue() == Team.Relation.ALLY).map(Map.Entry::getKey).collect(Collectors.toSet());
        for (Team allie : allies) {
            OfflinePlayer offlineMember = Bukkit.getOfflinePlayer((UUID)allie.getOwner());
            group.addElement(new DynamicGuiElement('g', viewer -> new StaticGuiElement('g', TeamList.createPlayerSkull(offlineMember), 1, click -> {
                if (click.getType().isRightClick()) {
                    if (this.plugin.getTeamStorageUtil().isTeamOwner(this.player) || this.plugin.getTeamStorageUtil().isTeamManager(this.player) && team.hasPermission(Team.Permission.RELATIONS)) {
                        this.plugin.getTeamStorageUtil().removeTeamAlly(team, allie, this.player);
                        team.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getRemovedTeamFromYourAllies().replace("%ALLYTEAM%", allie.getName()), new String[0]));
                        allie.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getTeamRemovedFromOtherAllies().replace("%TEAM%", team.getName()), new String[0]));
                        click.getGui().close();
                        new AlliesManager(this.plugin, this.player);
                    } else {
                        this.player.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                    }
                }
                return true;
            }, (String[])this.plugin.getTeamsGui().getAlliesManagerGuiText().stream().map(s -> s.replaceAll("%NAME%", allie.getName())).toArray(String[]::new))));
        }
        gui.addElement(group);
        gui.show((HumanEntity)this.player);
    }
}

