/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.gui;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.gui.AlliesManager;
import dev.xf3d3.ultimateteams.gui.EnemiesManager;
import dev.xf3d3.ultimateteams.gui.MembersManager;
import dev.xf3d3.ultimateteams.gui.TeamList;
import dev.xf3d3.ultimateteams.gui.WarpsManager;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.DynamicGuiElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.InventoryGui;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Optional;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TeamManager {
    private final UltimateTeams plugin;
    private final Player player;

    public TeamManager(@NotNull UltimateTeams plugin, @NotNull Player player) {
        this.plugin = plugin;
        this.player = player;
        this.open();
    }

    private void open() {
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, (InventoryHolder)this.player, Utils.Color(this.plugin.getTeamsGui().getTeamsManagerGuiName()), this.plugin.getTeamsGui().getTeamsManagerguiSetup().toArray(new String[0]), new GuiElement[0]);
        Optional<Team> OptionalTeam = this.plugin.getTeamStorageUtil().findTeamByMember(this.player.getUniqueId());
        if (OptionalTeam.isEmpty()) {
            throw new IllegalStateException("Team not found");
        }
        Team team = OptionalTeam.get();
        gui.addElement(new StaticGuiElement('y', new ItemStack(this.plugin.getTeamsGui().getCloseButtonMaterial()), 1, click -> {
            click.getGui().close();
            return true;
        }, this.plugin.getTeamsGui().getCloseButtonName()));
        gui.addElement(new StaticGuiElement('x', new ItemStack(this.plugin.getTeamsGui().getTeamsManagerGuiInfoMaterial()), 1, click -> true, TeamList.getTeamInfo(this.plugin, team).toArray(new String[0])));
        DynamicGuiElement home = new DynamicGuiElement('a', viewer -> new StaticGuiElement('a', new ItemStack(this.plugin.getTeamsGui().getTeamsManagerGuiHomeMaterial()), 1, click -> {
            if (click.getType().isLeftClick()) {
                if (team.getHome() != null) {
                    this.plugin.getUtils().teleportPlayer(this.player, team.getHome().getLocation(), team.getHome().getServer(), Utils.TeleportType.HOME, null);
                }
                click.getGui().close();
            }
            if (click.getType().isRightClick()) {
                if (this.plugin.getTeamStorageUtil().isTeamOwner(this.player) || this.plugin.getTeamStorageUtil().isTeamManager(this.player) && team.hasPermission(Team.Permission.HOME)) {
                    this.plugin.getTeamStorageUtil().deleteHome(this.player, team);
                    this.player.sendMessage(MineDown.parse(this.plugin.getMessages().getSuccessfullyDeletedTeamHome(), new String[0]));
                    click.getGui().draw();
                } else {
                    this.player.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                }
            }
            return true;
        }, (String[])this.plugin.getTeamsGui().getTeamsManagerGuiHomeText().stream().map(s -> s.replaceAll("%HOMESET%", this.plugin.getTeamStorageUtil().findTeamByMember(this.player.getUniqueId()).map(t -> team.getHome() != null ? "TRUE" : "FALSE").orElse("Team Not Found"))).toArray(String[]::new)));
        if (this.plugin.getSettings().teamHomeEnabled()) {
            gui.addElement(home);
        }
        StaticGuiElement warps = new StaticGuiElement('b', new ItemStack(this.plugin.getTeamsGui().getTeamsManagerGuiWarpsMaterial()), 1, click -> {
            if (click.getType().isLeftClick()) {
                click.getGui().close();
                new WarpsManager(this.plugin, this.player);
            }
            return true;
        }, this.plugin.getTeamsGui().getTeamsManagerGuiWarpsText().toArray(new String[0]));
        if (this.plugin.getSettings().teamWarpEnabled()) {
            gui.addElement(warps);
        }
        gui.addElement(new StaticGuiElement('c', new ItemStack(this.plugin.getTeamsGui().getTeamsManagerGuiMembersMaterial()), 1, click -> {
            if (click.getType().isLeftClick()) {
                click.getGui().close();
                new MembersManager(this.plugin, this.player);
            }
            return true;
        }, this.plugin.getTeamsGui().getTeamsManagerGuiMembersText().toArray(new String[0])));
        DynamicGuiElement pvp = new DynamicGuiElement('d', viewer -> new StaticGuiElement('d', new ItemStack(this.plugin.getTeamsGui().getTeamsManagerGuiPvpMaterial()), 1, click -> {
            if (click.getType().isLeftClick()) {
                if (this.plugin.getTeamStorageUtil().isTeamOwner(this.player) || this.plugin.getTeamStorageUtil().isTeamManager(this.player) && team.hasPermission(Team.Permission.PVP)) {
                    if (team.isFriendlyFireAllowed()) {
                        team.setFriendlyFire(false);
                        this.player.sendMessage(MineDown.parse(this.plugin.getMessages().getDisabledFriendlyFire(), new String[0]));
                    } else {
                        team.setFriendlyFire(true);
                        this.player.sendMessage(MineDown.parse(this.plugin.getMessages().getEnabledFriendlyFire(), new String[0]));
                    }
                    this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(this.player, team));
                    click.getGui().draw();
                } else {
                    this.player.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                }
            }
            return true;
        }, (String[])this.plugin.getTeamsGui().getTeamsManagerGuiPvpText().stream().map(s -> s.replaceAll("%ENABLED%", String.valueOf(this.plugin.getTeamStorageUtil().findTeamByMember(this.player.getUniqueId()).map(Team::isFriendlyFire).orElse(null)).toUpperCase())).toArray(String[]::new)));
        if (this.plugin.getSettings().isPvpCommandEnabled()) {
            gui.addElement(pvp);
        }
        gui.addElement(new StaticGuiElement('e', new ItemStack(this.plugin.getTeamsGui().getTeamsManagerGuiAlliesMaterial()), 1, click -> {
            if (click.getType().isLeftClick()) {
                click.getGui().close();
                new AlliesManager(this.plugin, this.player);
            }
            return true;
        }, this.plugin.getTeamsGui().getTeamsManagerGuiAlliesText().toArray(new String[0])));
        gui.addElement(new StaticGuiElement('h', new ItemStack(this.plugin.getTeamsGui().getTeamsManagerGuiEnemiesMaterial()), 1, click -> {
            if (click.getType().isLeftClick()) {
                click.getGui().close();
                new EnemiesManager(this.plugin, this.player);
            }
            return true;
        }, this.plugin.getTeamsGui().getTeamsManagerGuiEnemiesText().toArray(new String[0])));
        gui.show((HumanEntity)this.player);
    }
}

