/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.hooks;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.huskhomes.api.HuskHomesAPI;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleportable;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class HuskHomesHook {
    private final HuskHomesAPI huskHomesAPI = HuskHomesAPI.getInstance();
    private final UltimateTeams plugin;

    public HuskHomesHook(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.sendMessages();
    }

    public void teleportPlayer(@NotNull Player player, @NotNull Location location, @NotNull String server) {
        OnlineUser onlineUser = this.huskHomesAPI.adaptUser(player);
        Position position = Position.at((double)location.getX(), (double)location.getY(), (double)location.getZ(), (World)World.from((String)location.getWorld().getName(), (UUID)location.getWorld().getUID()), (String)server);
        try {
            this.huskHomesAPI.teleportBuilder().teleporter((Teleportable)onlineUser).target((Target)position).toTimedTeleport().execute();
        }
        catch (TeleportationException e) {
            this.plugin.log(Level.SEVERE, "Error while trying to teleport a player using HuskHomes", e);
            e.displayMessage((CommandUser)onlineUser, new String[0]);
        }
    }

    private void sendMessages() {
        this.plugin.sendConsole("-------------------------------------------");
        this.plugin.sendConsole("&6UltimateTeams: &3Hooked into HuskHomes");
        this.plugin.sendConsole("&6UltimateTeams: &3Now using HuskHomes as teleportation handler!");
        this.plugin.sendConsole("-------------------------------------------");
    }
}

