/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.hooks;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.utils.LuckPermsContexts.IsInTeamContext;
import dev.xf3d3.ultimateteams.utils.LuckPermsContexts.TeamContext;
import dev.xf3d3.ultimateteams.utils.LuckPermsContexts.TeamOwnerContext;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class LuckPermsHook {
    private final UltimateTeams plugin;
    private ContextManager contexts;

    public LuckPermsHook(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.registerServiceProvider();
    }

    private void registerServiceProvider() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider == null) {
            throw new IllegalStateException("Could not resolve LuckPerms provider");
        }
        LuckPerms api = (LuckPerms)provider.getProvider();
        this.contexts = api.getContextManager();
        this.registerCalculator(() -> new IsInTeamContext(this.plugin));
        this.registerCalculator(() -> new TeamOwnerContext(this.plugin));
        this.registerCalculator(() -> new TeamContext(this.plugin));
        this.sendMessages();
    }

    private void registerCalculator(Supplier<ContextCalculator<Player>> calculatorSupplier) {
        ContextCalculator<Player> contextCalculator = calculatorSupplier.get();
        this.contexts.registerCalculator(contextCalculator);
    }

    private void sendMessages() {
        this.plugin.log(Level.INFO, "-------------------------------------------", new Throwable[0]);
        this.plugin.log(Level.INFO, "&6UltimateTeams: &3Hooked into LuckPerms", new Throwable[0]);
        this.plugin.log(Level.INFO, "&6UltimateTeams: &3Contexts registered!", new Throwable[0]);
        this.plugin.log(Level.INFO, "-------------------------------------------", new Throwable[0]);
    }
}

