/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.hooks;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private final Economy economyAPI;
    private final UltimateTeams plugin;

    public VaultHook(@NotNull UltimateTeams plugin) {
        RegisteredServiceProvider economyProvider = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider == null) {
            throw new IllegalStateException("Could not resolve economy provider");
        }
        this.economyAPI = (Economy)economyProvider.getProvider();
        this.plugin = plugin;
        this.sendMessages();
    }

    public boolean hasMoney(@NotNull Player player, @NotNull Double amount) {
        return this.economyAPI.has((OfflinePlayer)player, amount.doubleValue());
    }

    public String getCurrencyNameSingular() {
        return this.economyAPI.currencyNameSingular();
    }

    public String getCurrencyNamePlural() {
        return this.economyAPI.currencyNamePlural();
    }

    public boolean takeMoney(@NotNull Player player, @NotNull Double amount) {
        return this.economyAPI.withdrawPlayer((OfflinePlayer)player, amount.doubleValue()).transactionSuccess();
    }

    public void giveMoney(@NotNull Player player, @NotNull Double amount) {
        this.economyAPI.depositPlayer((OfflinePlayer)player, amount.doubleValue());
    }

    private void sendMessages() {
        this.plugin.sendConsole("-------------------------------------------");
        this.plugin.sendConsole("&6UltimateTeams: &3Hooked into Vault");
        this.plugin.sendConsole("&6UltimateTeams: &3Economy features enabled!");
        this.plugin.sendConsole("-------------------------------------------");
    }
}

