/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.listeners;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamFriendlyFireEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class PlayerDamageEvent
implements Listener {
    private final Map<Block, UUID> explodingAnchors = new ConcurrentHashMap<Block, UUID>();
    private final UltimateTeams plugin;

    public PlayerDamageEvent(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Player attackingPlayer = null;
        if (e.getDamager() instanceof Player) {
            attackingPlayer = (Player)e.getDamager();
        } else {
            Entity entity2 = e.getDamager();
            if (entity2 instanceof Projectile) {
                Projectile projectile = (Projectile)entity2;
                ProjectileSource projectileSource = projectile.getShooter();
                if (projectileSource instanceof Player) {
                    shooter = (Player)projectileSource;
                    attackingPlayer = shooter;
                }
            } else {
                shooter = e.getDamager();
                if (shooter instanceof Firework) {
                    Firework firework = (Firework)shooter;
                    ProjectileSource projectileSource = firework.getShooter();
                    if (projectileSource instanceof Player) {
                        shooter = (Player)projectileSource;
                        attackingPlayer = shooter;
                    }
                } else {
                    shooter = e.getDamager();
                    if (shooter instanceof TNTPrimed) {
                        TNTPrimed tntPrimed = (TNTPrimed)shooter;
                        Entity entity3 = tntPrimed.getSource();
                        if (entity3 instanceof Player) {
                            shooter = (Player)entity3;
                            attackingPlayer = shooter;
                        }
                    } else {
                        EnderCrystal crystal;
                        shooter = e.getDamager();
                        if (shooter instanceof EnderCrystal && (crystal = (EnderCrystal)shooter).hasMetadata("exploder")) {
                            UUID uuid = UUID.fromString(((MetadataValue)crystal.getMetadata("exploder").get(0)).asString());
                            attackingPlayer = Bukkit.getPlayer((UUID)uuid);
                            System.out.println("b");
                            crystal.removeMetadata("exploder", (Plugin)this.plugin);
                        }
                    }
                }
            }
        }
        if (attackingPlayer == null) {
            return;
        }
        if (attackingPlayer.getUniqueId() == victim.getUniqueId()) {
            return;
        }
        Team attackerTeam = this.plugin.getTeamStorageUtil().findTeamByMember(attackingPlayer.getUniqueId()).orElse(null);
        Team victimTeam = this.plugin.getTeamStorageUtil().findTeamByMember(victim.getUniqueId()).orElse(null);
        if (attackerTeam == null || victimTeam == null || attackingPlayer.hasPermission("ultimateteams.bypass.pvp") && this.plugin.getSettings().enablePvPBypassPermission()) {
            return;
        }
        if (attackerTeam.equals(victimTeam) && !attackerTeam.isFriendlyFire()) {
            e.setCancelled(true);
            attackingPlayer.sendMessage(MineDown.parse(this.plugin.getMessages().getFriendlyFireIsDisabled(), new String[0]));
            new TeamFriendlyFireEvent(attackingPlayer, victim, attackerTeam, victimTeam).callEvent();
            return;
        }
        if (attackerTeam.areRelationsBilateral(victimTeam, Team.Relation.ALLY)) {
            e.setCancelled(true);
            attackingPlayer.sendMessage(MineDown.parse(this.plugin.getMessages().getFriendlyFireIsDisabledForAllies(), new String[0]));
        }
    }

    @EventHandler
    public void onCrystalHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof EnderCrystal)) {
            return;
        }
        EnderCrystal crystal = (EnderCrystal)entity;
        Player player = null;
        Entity entity2 = e.getDamager();
        if (entity2 instanceof Player) {
            Player p;
            player = p = (Player)entity2;
        } else {
            Projectile proj;
            entity2 = e.getDamager();
            if (entity2 instanceof Projectile && (entity2 = (proj = (Projectile)entity2).getShooter()) instanceof Player) {
                Player p2;
                player = p2 = (Player)entity2;
            }
        }
        if (player != null) {
            crystal.setMetadata("exploder", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getUniqueId().toString()));
            System.out.println("a");
        }
    }
}

