/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.listeners;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.User;
import dev.xf3d3.ultimateteams.network.Broker;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerDisconnectEvent
implements Listener {
    private final UltimateTeams plugin;

    public PlayerDisconnectEvent(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getUsersStorageUtil().removePlayer(player.getUniqueId());
        this.plugin.getUsersStorageUtil().getOnlineUserMap().remove(player.getUniqueId());
        if (this.plugin.getSettings().isEnableCrossServer()) {
            List<User> localPlayerList = this.plugin.getUsersStorageUtil().getOnlineUserMap().values().stream().filter(u -> !u.equals((Object)player)).map(u -> User.of(u.getUniqueId(), u.getName())).toList();
            if (this.plugin.getSettings().getBrokerType() == Broker.Type.REDIS) {
                this.plugin.getUsersStorageUtil().syncGlobalUserList(player, localPlayerList);
            } else {
                this.plugin.getUsersStorageUtil().getOnlineUserMap().values().stream().filter(u -> !u.equals((Object)player)).findAny().ifPresent(user -> this.plugin.getUsersStorageUtil().syncGlobalUserList((Player)user, localPlayerList));
            }
        }
    }
}

