/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.models;

import dev.xf3d3.ultimateteams.libraries.gson.annotations.Expose;
import dev.xf3d3.ultimateteams.libraries.gson.annotations.SerializedName;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.models.Position;
import java.util.Optional;
import lombok.Generated;

public class Preferences {
    @Expose
    @SerializedName(value="team_chat_talking")
    private boolean teamChatTalking;
    @Expose
    @SerializedName(value="team_chat_spying")
    private boolean teamChatSpying;
    @Expose
    @SerializedName(value="invitations_status")
    private boolean acceptInvitations = true;
    @Expose
    @SerializedName(value="teleport_target")
    @Nullable
    private Position teleportTarget;

    @NotNull
    public static Preferences getDefaults() {
        return new Preferences(false, false, true);
    }

    private Preferences(boolean teamChatTalking, boolean teamChatSpying, boolean invitationsStatus) {
        this.teamChatTalking = teamChatTalking;
        this.teamChatSpying = teamChatSpying;
        this.acceptInvitations = invitationsStatus;
    }

    private Preferences() {
    }

    public Optional<Position> getTeleportTarget() {
        return Optional.ofNullable(this.teleportTarget);
    }

    public void setTeleportTarget(@NotNull Position target) {
        this.teleportTarget = target;
    }

    public void clearTeleportTarget() {
        this.teleportTarget = null;
    }

    @Generated
    public void setTeamChatTalking(boolean teamChatTalking) {
        this.teamChatTalking = teamChatTalking;
    }

    @Generated
    public boolean isTeamChatTalking() {
        return this.teamChatTalking;
    }

    @Generated
    public void setTeamChatSpying(boolean teamChatSpying) {
        this.teamChatSpying = teamChatSpying;
    }

    @Generated
    public boolean isTeamChatSpying() {
        return this.teamChatSpying;
    }

    @Generated
    public void setAcceptInvitations(boolean acceptInvitations) {
        this.acceptInvitations = acceptInvitations;
    }

    @Generated
    public boolean isAcceptInvitations() {
        return this.acceptInvitations;
    }
}

