/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.models;

import com.google.common.collect.Maps;
import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.gson.annotations.Expose;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.ApiStatus;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.models.TeamEnderChest;
import dev.xf3d3.ultimateteams.models.TeamHome;
import dev.xf3d3.ultimateteams.models.TeamWarp;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Team {
    public int id;
    @Expose
    private String name;
    @Expose
    private double balance;
    @Expose
    private double join_fee;
    @Expose
    @Nullable
    private String prefix;
    @Expose
    private Map<String, TeamWarp> warps;
    @Expose
    private Map<UUID, Integer> members;
    @Expose
    private Map<Integer, Relation> relations;
    @Expose
    private boolean friendlyFire;
    @Expose
    @Nullable
    private TeamHome home;
    @Expose
    private EnumSet<Permission> permissions;
    @Expose
    private Map<Integer, TeamEnderChest> enderChests;

    @NotNull
    @ApiStatus.Internal
    public static Team create(@NotNull String name, @NotNull Player owner, @NotNull Boolean friendlyFire, @NotNull Integer rows) {
        TeamEnderChest defaultChest = TeamEnderChest.builder().chestNumber(1).rows(rows).serializedContents("").build();
        HashMap defaultChests = Maps.newHashMap();
        defaultChests.put(1, defaultChest);
        return Team.builder().name(name).friendlyFire(friendlyFire).enderChests(defaultChests).members(Maps.newHashMap(Map.of(owner.getUniqueId(), 3))).build();
    }

    public List<Player> getOnlineMembers() {
        return Bukkit.getOnlinePlayers().stream().filter(player -> this.getMembers().containsKey(player.getUniqueId())).collect(Collectors.toUnmodifiableList());
    }

    public void sendTeamMessage(@NotNull String message) {
        Bukkit.getOnlinePlayers().stream().filter(player -> this.getMembers().containsKey(player.getUniqueId())).forEach(player -> player.sendMessage(message));
    }

    public void sendTeamMessage(@NotNull Component component) {
        Bukkit.getOnlinePlayers().stream().filter(player -> this.getMembers().containsKey(player.getUniqueId())).forEach(player -> player.sendMessage(component));
    }

    public Optional<TeamWarp> getTeamWarp(@NotNull String name) {
        return Optional.ofNullable(this.warps.get(name));
    }

    public void addTeamWarp(@NotNull TeamWarp warp) {
        this.warps.put(warp.getName(), warp);
    }

    public void removeTeamWarp(@NotNull String name) {
        this.warps.remove(name);
    }

    @NotNull
    public UUID getOwner() {
        return this.members.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElseThrow(() -> new IllegalStateException("Team \"" + this.getName() + "\" has no owner"));
    }

    public void addMember(@NotNull UUID uuid, @Nullable Integer weight) {
        this.members.put(uuid, Objects.requireNonNullElse(weight, 1));
    }

    public void removeMember(@NotNull UUID uuid) throws IllegalArgumentException {
        if (this.getOwner().equals(uuid)) {
            throw new IllegalArgumentException("Cannot remove the mayor of the team \"" + this.getName() + "\"");
        }
        this.members.remove(uuid);
    }

    @NotNull
    public Map<Integer, Relation> getRelations() {
        return this.relations == null ? (this.relations = new HashMap<Integer, Relation>()) : this.relations;
    }

    @NotNull
    public Map<Team, Relation> getRelations(@NotNull UltimateTeams plugin) {
        return this.getRelations().entrySet().stream().filter(e -> plugin.getTeamStorageUtil().findTeam((Integer)e.getKey()).isPresent()).collect(Collectors.toMap(e -> plugin.getTeamStorageUtil().findTeam((Integer)e.getKey()).orElse(null), Map.Entry::getValue));
    }

    @NotNull
    public Relation getRelationWith(@NotNull Team otherTeam) {
        return this.relations.getOrDefault(otherTeam.getId(), Relation.NEUTRAL);
    }

    public void setRelationWith(@NotNull Team otherTeam, @NotNull Relation relation) {
        this.relations.remove(otherTeam.getId());
        this.relations.put(otherTeam.getId(), relation);
    }

    public void removeRelationWith(@NotNull Team otherTeam) {
        this.relations.remove(otherTeam.getId());
    }

    @NotNull
    public Set<Permission> getPermissions() {
        EnumSet<Permission> enumSet;
        if (this.permissions == null) {
            this.permissions = EnumSet.noneOf(Permission.class);
            enumSet = this.permissions;
        } else {
            enumSet = EnumSet.copyOf(this.permissions);
        }
        return enumSet;
    }

    public void addPermission(Permission perm) {
        this.permissions.add(perm);
    }

    public void removePermission(Permission perm) {
        this.permissions.remove((Object)perm);
    }

    public boolean hasPermission(Permission perm) {
        return this.permissions.contains((Object)perm);
    }

    public boolean isFriendlyFireAllowed() {
        return this.friendlyFire;
    }

    public boolean areRelationsBilateral(@NotNull Team otherTeam, @NotNull Relation relation) {
        if (otherTeam.equals(this)) {
            return true;
        }
        return this.getRelationWith(otherTeam) == relation && otherTeam.getRelationWith(this) == relation;
    }

    public void addBalance(double balance) {
        this.balance += balance;
    }

    public boolean subBalance(double amount) {
        if (amount <= 0.0) {
            return false;
        }
        if (amount > this.balance) {
            return false;
        }
        this.balance -= amount;
        return true;
    }

    public Optional<TeamEnderChest> getEnderChest(int chestNumber) {
        return Optional.ofNullable(this.enderChests.get(chestNumber));
    }

    public void setEnderChest(@NotNull TeamEnderChest chest) {
        this.enderChests.put(chest.getChestNumber(), chest);
    }

    public void removeEnderChest(int chestNumber) {
        this.enderChests.remove(chestNumber);
    }

    public int getEnderChestCount() {
        return this.enderChests.size();
    }

    public boolean hasEnderChest(int chestNumber) {
        return this.enderChests.containsKey(chestNumber);
    }

    @Generated
    private static int $default$id() {
        return 0;
    }

    @Generated
    private static String $default$prefix() {
        return null;
    }

    @Generated
    private static Map<String, TeamWarp> $default$warps() {
        return Maps.newHashMap();
    }

    @Generated
    private static Map<UUID, Integer> $default$members() {
        return Maps.newHashMap();
    }

    @Generated
    private static Map<Integer, Relation> $default$relations() {
        return Maps.newHashMap();
    }

    @Generated
    private static boolean $default$friendlyFire() {
        return false;
    }

    @Generated
    private static TeamHome $default$home() {
        return null;
    }

    @Generated
    private static EnumSet<Permission> $default$permissions() {
        return EnumSet.noneOf(Permission.class);
    }

    @Generated
    private static Map<Integer, TeamEnderChest> $default$enderChests() {
        return Maps.newHashMap();
    }

    @Generated
    public static TeamBuilder builder() {
        return new TeamBuilder();
    }

    @Generated
    private Team() {
        this.id = Team.$default$id();
        this.prefix = Team.$default$prefix();
        this.warps = Team.$default$warps();
        this.members = Team.$default$members();
        this.relations = Team.$default$relations();
        this.friendlyFire = Team.$default$friendlyFire();
        this.home = Team.$default$home();
        this.permissions = Team.$default$permissions();
        this.enderChests = Team.$default$enderChests();
    }

    @Generated
    private Team(int id, String name, double balance, double join_fee, @Nullable String prefix, Map<String, TeamWarp> warps, Map<UUID, Integer> members, Map<Integer, Relation> relations, boolean friendlyFire, @Nullable TeamHome home, EnumSet<Permission> permissions, Map<Integer, TeamEnderChest> enderChests) {
        this.id = id;
        this.name = name;
        this.balance = balance;
        this.join_fee = join_fee;
        this.prefix = prefix;
        this.warps = warps;
        this.members = members;
        this.relations = relations;
        this.friendlyFire = friendlyFire;
        this.home = home;
        this.permissions = permissions;
        this.enderChests = enderChests;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public double getBalance() {
        return this.balance;
    }

    @Generated
    public void setBalance(double balance) {
        this.balance = balance;
    }

    @Generated
    public double getJoin_fee() {
        return this.join_fee;
    }

    @Generated
    public void setJoin_fee(double join_fee) {
        this.join_fee = join_fee;
    }

    @Nullable
    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public void setPrefix(@Nullable String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public Map<String, TeamWarp> getWarps() {
        return this.warps;
    }

    @Generated
    public Map<UUID, Integer> getMembers() {
        return this.members;
    }

    @Generated
    public boolean isFriendlyFire() {
        return this.friendlyFire;
    }

    @Generated
    public void setFriendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    @Nullable
    @Generated
    public TeamHome getHome() {
        return this.home;
    }

    @Generated
    public void setHome(@Nullable TeamHome home) {
        this.home = home;
    }

    @Generated
    public void setPermissions(EnumSet<Permission> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public Map<Integer, TeamEnderChest> getEnderChests() {
        return this.enderChests;
    }

    @Generated
    public static class TeamBuilder {
        @Generated
        private boolean id$set;
        @Generated
        private int id$value;
        @Generated
        private String name;
        @Generated
        private double balance;
        @Generated
        private double join_fee;
        @Generated
        private boolean prefix$set;
        @Generated
        private String prefix$value;
        @Generated
        private boolean warps$set;
        @Generated
        private Map<String, TeamWarp> warps$value;
        @Generated
        private boolean members$set;
        @Generated
        private Map<UUID, Integer> members$value;
        @Generated
        private boolean relations$set;
        @Generated
        private Map<Integer, Relation> relations$value;
        @Generated
        private boolean friendlyFire$set;
        @Generated
        private boolean friendlyFire$value;
        @Generated
        private boolean home$set;
        @Generated
        private TeamHome home$value;
        @Generated
        private boolean permissions$set;
        @Generated
        private EnumSet<Permission> permissions$value;
        @Generated
        private boolean enderChests$set;
        @Generated
        private Map<Integer, TeamEnderChest> enderChests$value;

        @Generated
        TeamBuilder() {
        }

        @Generated
        public TeamBuilder id(int id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @Generated
        public TeamBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public TeamBuilder balance(double balance) {
            this.balance = balance;
            return this;
        }

        @Generated
        public TeamBuilder join_fee(double join_fee) {
            this.join_fee = join_fee;
            return this;
        }

        @Generated
        public TeamBuilder prefix(@Nullable String prefix) {
            this.prefix$value = prefix;
            this.prefix$set = true;
            return this;
        }

        @Generated
        public TeamBuilder warps(Map<String, TeamWarp> warps) {
            this.warps$value = warps;
            this.warps$set = true;
            return this;
        }

        @Generated
        public TeamBuilder members(Map<UUID, Integer> members) {
            this.members$value = members;
            this.members$set = true;
            return this;
        }

        @Generated
        public TeamBuilder relations(Map<Integer, Relation> relations) {
            this.relations$value = relations;
            this.relations$set = true;
            return this;
        }

        @Generated
        public TeamBuilder friendlyFire(boolean friendlyFire) {
            this.friendlyFire$value = friendlyFire;
            this.friendlyFire$set = true;
            return this;
        }

        @Generated
        public TeamBuilder home(@Nullable TeamHome home) {
            this.home$value = home;
            this.home$set = true;
            return this;
        }

        @Generated
        public TeamBuilder permissions(EnumSet<Permission> permissions) {
            this.permissions$value = permissions;
            this.permissions$set = true;
            return this;
        }

        @Generated
        public TeamBuilder enderChests(Map<Integer, TeamEnderChest> enderChests) {
            this.enderChests$value = enderChests;
            this.enderChests$set = true;
            return this;
        }

        @Generated
        public Team build() {
            int id$value = this.id$value;
            if (!this.id$set) {
                id$value = Team.$default$id();
            }
            String prefix$value = this.prefix$value;
            if (!this.prefix$set) {
                prefix$value = Team.$default$prefix();
            }
            Map<String, TeamWarp> warps$value = this.warps$value;
            if (!this.warps$set) {
                warps$value = Team.$default$warps();
            }
            Map<UUID, Integer> members$value = this.members$value;
            if (!this.members$set) {
                members$value = Team.$default$members();
            }
            Map<Integer, Relation> relations$value = this.relations$value;
            if (!this.relations$set) {
                relations$value = Team.$default$relations();
            }
            boolean friendlyFire$value = this.friendlyFire$value;
            if (!this.friendlyFire$set) {
                friendlyFire$value = Team.$default$friendlyFire();
            }
            TeamHome home$value = this.home$value;
            if (!this.home$set) {
                home$value = Team.$default$home();
            }
            EnumSet<Permission> permissions$value = this.permissions$value;
            if (!this.permissions$set) {
                permissions$value = Team.$default$permissions();
            }
            Map<Integer, TeamEnderChest> enderChests$value = this.enderChests$value;
            if (!this.enderChests$set) {
                enderChests$value = Team.$default$enderChests();
            }
            return new Team(id$value, this.name, this.balance, this.join_fee, prefix$value, warps$value, members$value, relations$value, friendlyFire$value, home$value, permissions$value, enderChests$value);
        }

        @Generated
        public String toString() {
            return "Team.TeamBuilder(id$value=" + this.id$value + ", name=" + this.name + ", balance=" + this.balance + ", join_fee=" + this.join_fee + ", prefix$value=" + this.prefix$value + ", warps$value=" + String.valueOf(this.warps$value) + ", members$value=" + String.valueOf(this.members$value) + ", relations$value=" + String.valueOf(this.relations$value) + ", friendlyFire$value=" + this.friendlyFire$value + ", home$value=" + String.valueOf(this.home$value) + ", permissions$value=" + String.valueOf(this.permissions$value) + ", enderChests$value=" + String.valueOf(this.enderChests$value) + ")";
        }
    }

    public static enum Relation {
        ALLY,
        NEUTRAL,
        ENEMY;


        public static Optional<Relation> parse(@NotNull String string) {
            return Arrays.stream(Relation.values()).filter(operation -> operation.name().equalsIgnoreCase(string)).findFirst();
        }
    }

    public static enum Permission {
        INVITE,
        KICK,
        PVP,
        RELATIONS,
        WARPS,
        RENAME,
        PREFIX,
        HOME,
        PROMOTE,
        FEE,
        WITHDRAW,
        DEPOSIT;


        public static Optional<Permission> parse(@NotNull String string) {
            return Arrays.stream(Permission.values()).filter(operation -> operation.name().equalsIgnoreCase(string)).findFirst();
        }
    }
}

