/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.models;

import dev.xf3d3.ultimateteams.libraries.gson.annotations.Expose;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class TeamEnderChest {
    @Expose
    private int chestNumber;
    @Expose
    private int rows;
    @Expose
    @Nullable
    private String serializedContents;

    public int getSize() {
        return this.rows * 9;
    }

    @NotNull
    public static String serializeContents(@NotNull ItemStack[] contents) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(contents.length);
            for (ItemStack item : contents) {
                dataOutput.writeObject((Object)item);
            }
            dataOutput.close();
            return Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @NotNull
    public static ItemStack[] deserializeContents(@Nullable String data, int size) {
        if (data == null || data.isEmpty()) {
            return new ItemStack[size];
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            int length = dataInput.readInt();
            ItemStack[] contents = new ItemStack[length];
            for (int i = 0; i < length; ++i) {
                contents[i] = (ItemStack)dataInput.readObject();
            }
            dataInput.close();
            return contents;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ItemStack[size];
        }
    }

    @NotNull
    public ItemStack[] getContents() {
        return TeamEnderChest.deserializeContents(this.serializedContents, this.getSize());
    }

    public void setContents(@NotNull ItemStack[] contents) {
        this.serializedContents = TeamEnderChest.serializeContents(contents);
    }

    @Generated
    public static TeamEnderChestBuilder builder() {
        return new TeamEnderChestBuilder();
    }

    @Generated
    private TeamEnderChest() {
    }

    @Generated
    private TeamEnderChest(int chestNumber, int rows, @Nullable String serializedContents) {
        this.chestNumber = chestNumber;
        this.rows = rows;
        this.serializedContents = serializedContents;
    }

    @Generated
    public int getChestNumber() {
        return this.chestNumber;
    }

    @Generated
    public void setChestNumber(int chestNumber) {
        this.chestNumber = chestNumber;
    }

    @Generated
    public int getRows() {
        return this.rows;
    }

    @Generated
    public void setRows(int rows) {
        this.rows = rows;
    }

    @Nullable
    @Generated
    public String getSerializedContents() {
        return this.serializedContents;
    }

    @Generated
    public void setSerializedContents(@Nullable String serializedContents) {
        this.serializedContents = serializedContents;
    }

    @Generated
    public static class TeamEnderChestBuilder {
        @Generated
        private int chestNumber;
        @Generated
        private int rows;
        @Generated
        private String serializedContents;

        @Generated
        TeamEnderChestBuilder() {
        }

        @Generated
        public TeamEnderChestBuilder chestNumber(int chestNumber) {
            this.chestNumber = chestNumber;
            return this;
        }

        @Generated
        public TeamEnderChestBuilder rows(int rows) {
            this.rows = rows;
            return this;
        }

        @Generated
        public TeamEnderChestBuilder serializedContents(@Nullable String serializedContents) {
            this.serializedContents = serializedContents;
            return this;
        }

        @Generated
        public TeamEnderChest build() {
            return new TeamEnderChest(this.chestNumber, this.rows, this.serializedContents);
        }

        @Generated
        public String toString() {
            return "TeamEnderChest.TeamEnderChestBuilder(chestNumber=" + this.chestNumber + ", rows=" + this.rows + ", serializedContents=" + this.serializedContents + ")";
        }
    }
}

