/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.models;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.models.Preferences;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.entity.Player;

public class TeamPlayer {
    private final UltimateTeams plugin = UltimateTeams.getPlugin();
    private UUID javaUUID;
    private String lastPlayerName;
    private boolean isBedrockPlayer;
    private String bedrockUUID;
    private Preferences preferences;

    public TeamPlayer(@NotNull UUID UUID2, @NotNull String playerName, @Nullable Boolean isBedrock, @Nullable String bedrockUuid, @Nullable Preferences preferences) {
        this.javaUUID = UUID2;
        this.lastPlayerName = playerName;
        this.isBedrockPlayer = isBedrock != null ? isBedrock : false;
        this.bedrockUUID = bedrockUuid;
        this.preferences = preferences != null ? preferences : Preferences.getDefaults();
    }

    public final int getMaxWarps(Player player, int defaultMaxWarps, boolean stackWarps) {
        List<Integer> warps = this.plugin.getUtils().getNumberPermission(player, "ultimateteams.max_warps.");
        if (warps.isEmpty()) {
            if (this.plugin.getSettings().debugModeEnabled()) {
                this.plugin.log(Level.INFO, "Max Warps (default - permission empty)" + defaultMaxWarps, new Throwable[0]);
            }
            return defaultMaxWarps;
        }
        if (stackWarps) {
            if (this.plugin.getSettings().debugModeEnabled()) {
                this.plugin.log(Level.INFO, "Max Warps (stacked)" + defaultMaxWarps + String.valueOf(warps.stream().reduce(0, Integer::sum)), new Throwable[0]);
            }
            return defaultMaxWarps + warps.stream().reduce(0, Integer::sum);
        }
        if (this.plugin.getSettings().debugModeEnabled()) {
            this.plugin.log(Level.INFO, "Max Warps (permission)" + String.valueOf(warps.get(0)), new Throwable[0]);
        }
        return warps.get(0);
    }

    public final int getMaxMembers(Player player, int defaultMaxMembers, boolean stackMembers) {
        List<Integer> membersPerm = this.plugin.getUtils().getNumberPermission(player, "ultimateteams.max_members.");
        if (membersPerm.isEmpty()) {
            if (this.plugin.getSettings().debugModeEnabled()) {
                this.plugin.log(Level.INFO, "Max Members (default - permission empty)" + defaultMaxMembers, new Throwable[0]);
            }
            return defaultMaxMembers;
        }
        if (stackMembers) {
            if (this.plugin.getSettings().debugModeEnabled()) {
                this.plugin.log(Level.INFO, "Max Members (stacked)" + defaultMaxMembers + String.valueOf(membersPerm.stream().reduce(0, Integer::sum)), new Throwable[0]);
            }
            return defaultMaxMembers + membersPerm.stream().reduce(0, Integer::sum);
        }
        if (this.plugin.getSettings().debugModeEnabled()) {
            this.plugin.log(Level.INFO, "Max Members (permission)" + String.valueOf(membersPerm.get(0)), new Throwable[0]);
        }
        return membersPerm.get(0);
    }

    @Generated
    public UUID getJavaUUID() {
        return this.javaUUID;
    }

    @Generated
    public void setJavaUUID(UUID javaUUID) {
        this.javaUUID = javaUUID;
    }

    @Generated
    public String getLastPlayerName() {
        return this.lastPlayerName;
    }

    @Generated
    public void setLastPlayerName(String lastPlayerName) {
        this.lastPlayerName = lastPlayerName;
    }

    @Generated
    public boolean isBedrockPlayer() {
        return this.isBedrockPlayer;
    }

    @Generated
    public void setBedrockPlayer(boolean isBedrockPlayer) {
        this.isBedrockPlayer = isBedrockPlayer;
    }

    @Generated
    public String getBedrockUUID() {
        return this.bedrockUUID;
    }

    @Generated
    public void setBedrockUUID(String bedrockUUID) {
        this.bedrockUUID = bedrockUUID;
    }

    @Generated
    public Preferences getPreferences() {
        return this.preferences;
    }

    @Generated
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }
}

