/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.utils;

import com.google.common.collect.Maps;
import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.TeamInvite;
import dev.xf3d3.ultimateteams.network.Broker;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.network.Payload;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TeamInviteUtil {
    private static final Map<UUID, TeamInvite> invites = Maps.newConcurrentMap();
    private final UltimateTeams plugin;

    public TeamInviteUtil(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public boolean createInvite(Integer id, Player inviter, UUID inviteeUUID) {
        this.clearExpiredInvites();
        Player player = Bukkit.getPlayer((UUID)inviteeUUID);
        TeamInvite invite = new TeamInvite(id, inviter.getUniqueId(), inviteeUUID, new Date().getTime(), null);
        if (player == null && this.plugin.getSettings().isEnableCrossServer()) {
            String senderName = Objects.requireNonNullElse(Bukkit.getOfflinePlayer((UUID)invite.getInvitee()).getName(), "");
            invites.put(inviter.getUniqueId(), invite);
            this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_INVITE_REQUEST).payload(Payload.invite(invite)).target(senderName, Message.TargetType.PLAYER).build().send((Broker)broker, inviter));
            return true;
        }
        if (player != null) {
            invites.put(inviter.getUniqueId(), invite);
            return true;
        }
        return false;
    }

    public void handleInboundInvite(Player invitee, TeamInvite invite) {
        this.plugin.getTeamStorageUtil().findTeam(invite.getTeamId()).ifPresent(team -> {
            invitee.sendMessage(MineDown.parse(String.join((CharSequence)"\n", this.plugin.getMessages().getTeamInviteInvitedMessage()).replace("%TEAM%", team.getName()).replace("%INVITER%", Objects.requireNonNullElse(Bukkit.getOfflinePlayer((UUID)invite.getInviter()).getName(), "player not found")), new String[0]));
            invites.put(invite.getInviter(), invite);
        });
    }

    public boolean hasInvitee(UUID inviteeUUID) {
        return invites.values().stream().anyMatch(invite -> invite.getInvitee().equals(inviteeUUID));
    }

    public Optional<TeamInvite> getInvite(UUID inviteeUUID) {
        return invites.values().stream().filter(invite -> invite.getInvitee().equals(inviteeUUID)).findFirst();
    }

    public void acceptInvite(TeamInvite invite, Player player) {
        String senderName = Objects.requireNonNullElse(Bukkit.getOfflinePlayer((UUID)invite.getInvitee()).getName(), "");
        this.removeInvite(invite.getInviter());
        invite.setAccepted(Boolean.TRUE);
        this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_INVITE_REPLY).payload(Payload.invite(invite)).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, player));
    }

    public boolean declineInvite(Player player) {
        Optional<TeamInvite> optionalTeamInvite = this.getInvite(player.getUniqueId());
        if (optionalTeamInvite.isEmpty()) {
            return false;
        }
        TeamInvite invite = optionalTeamInvite.get();
        invite.setAccepted(Boolean.FALSE);
        Player inviter = Bukkit.getPlayer((UUID)invite.getInviter());
        if (inviter != null) {
            inviter.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteDeniedInviter().replace("%PLAYER%", player.getName()), new String[0]));
        }
        String senderName = Objects.requireNonNullElse(Bukkit.getOfflinePlayer((UUID)invite.getInvitee()).getName(), "");
        this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_INVITE_REPLY).payload(Payload.invite(invite)).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, player));
        return this.removeInvitee(player.getUniqueId());
    }

    public void clearExpiredInvites() {
        int expiryTime = 25000;
        Date currentTime = new Date();
        invites.values().removeIf(invite -> currentTime.getTime() - invite.getInvitedAt() > (long)expiryTime);
        if (this.plugin.getSettings().debugModeEnabled()) {
            this.plugin.log(Level.INFO, Utils.Color("&6UltimateTeams-Debug: &aExpired team invites removed"), new Throwable[0]);
        }
    }

    public void emptyInviteList() {
        invites.clear();
    }

    public void removeInvite(UUID inviterUUID) {
        invites.remove(inviterUUID);
    }

    public boolean removeInvitee(UUID uuid) {
        return invites.values().removeIf(invite -> invite.getInvitee().equals(uuid));
    }

    public Set<Map.Entry<UUID, TeamInvite>> getInvites() {
        return invites.entrySet();
    }
}

