/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.utils;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Position;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class Utils {
    private final UltimateTeams plugin;

    public Utils(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teleportPlayer(@NotNull Player player, @NotNull Location location, @Nullable String server, @NotNull TeleportType teleportType, @Nullable String warpName) {
        String targetServer;
        String string = targetServer = server != null ? server : this.plugin.getSettings().getServerName();
        if (Bukkit.getPluginManager().getPlugin("HuskHomes") != null && this.plugin.getSettings().HuskHomesHook()) {
            this.plugin.getHuskHomesHook().teleportPlayer(player, location, targetServer);
            return;
        }
        if (this.plugin.getSettings().isEnableCrossServer() && !targetServer.equals(this.plugin.getSettings().getServerName())) {
            this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAccept(teamPlayer -> {
                teamPlayer.getPreferences().setTeleportTarget(Position.at(location.getX(), location.getY(), location.getZ(), location.getWorld().getName(), location.getYaw(), location.getPitch()));
                this.plugin.getUsersStorageUtil().updatePlayer((TeamPlayer)teamPlayer);
                this.plugin.getMessageBroker().ifPresent(broker -> broker.changeServer(player, targetServer));
            });
            return;
        }
        if (this.plugin.getSettings().getTeamHomeTpDelay() > 0 && teleportType.equals((Object)TeleportType.HOME)) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamHomeCooldownStart().replaceAll("%SECONDS%", String.valueOf(this.plugin.getSettings().getTeamHomeTpDelay())), new String[0]));
            this.plugin.runLater(() -> {
                this.plugin.getScheduler().teleportAsync((Entity)player, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getSuccessfullyTeleportedToHome(), new String[0]));
            }, this.plugin.getSettings().getTeamHomeTpDelay());
            return;
        }
        if (this.plugin.getSettings().getTeamWarpTpDelay() > 0 && teleportType.equals((Object)TeleportType.WARP)) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamWarpCooldownStart().replaceAll("%SECONDS%", String.valueOf(this.plugin.getSettings().getTeamWarpTpDelay())), new String[0]));
            this.plugin.runLater(() -> {
                this.plugin.getScheduler().teleportAsync((Entity)player, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamWarpTeleportedSuccessful().replaceAll("%WARP_NAME%", String.valueOf(warpName)), new String[0]));
            }, this.plugin.getSettings().getTeamWarpTpDelay());
            return;
        }
        this.plugin.getScheduler().teleportAsync((Entity)player, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public List<Integer> getNumberPermission(@NotNull Player player, @NotNull String permissionPrefix) {
        Map<String, Boolean> playerPermissions = player.getEffectivePermissions().stream().collect(Collectors.toMap(PermissionAttachmentInfo::getPermission, PermissionAttachmentInfo::getValue, (a, b) -> b));
        return playerPermissions.entrySet().stream().filter(Map.Entry::getValue).filter(permission -> ((String)permission.getKey()).startsWith(permissionPrefix)).filter(permission -> {
            try {
                Integer.parseInt(((String)permission.getKey()).substring(permissionPrefix.length()));
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }).map(permission -> Integer.parseInt(((String)permission.getKey()).substring(permissionPrefix.length()))).sorted(Collections.reverseOrder()).toList();
    }

    public static String Color(String message) {
        Pattern HEX_PATTERN = Pattern.compile("#([A-Fa-f0-9]{6})");
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder buffer = new StringBuilder();
        while (matcher.find()) {
            String hex = matcher.group(1);
            StringBuilder colorCode = new StringBuilder("\u00a7x");
            for (char c : hex.toCharArray()) {
                colorCode.append('\u00a7').append(c);
            }
            matcher.appendReplacement(buffer, colorCode.toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    public static String removeColors(String message) {
        if (message == null) {
            return null;
        }
        message = message.replaceAll("\u00a7[0-9A-FK-ORa-fk-or]", "");
        message = message.replaceAll("\u00a7x(\u00a7[0-9A-Fa-f]){6}", "");
        message = message.replaceAll("&[0-9A-FK-ORa-fk-or]", "");
        message = message.replaceAll("#[A-Fa-f0-9]{6}", "");
        return message;
    }

    public static enum TeleportType {
        WARP,
        HOME,
        SERVER;

    }
}

