/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.utils.gson;

import dev.xf3d3.ultimateteams.libraries.gson.Gson;
import dev.xf3d3.ultimateteams.libraries.gson.GsonBuilder;
import dev.xf3d3.ultimateteams.libraries.gson.JsonSyntaxException;
import dev.xf3d3.ultimateteams.libraries.gson.reflect.TypeToken;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Preferences;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.utils.gson.OffsetDateTimeConverter;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;

public interface GsonUtils {
    default public Gson getGson() {
        Type OFFSET_DATE_TIME_TYPE = new TypeToken<OffsetDateTime>(this){}.getType();
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(OFFSET_DATE_TIME_TYPE, new OffsetDateTimeConverter()).create();
    }

    @NotNull
    default public Message getMessageFromJson(@NotNull String json) throws JsonSyntaxException {
        return this.getGson().fromJson(json, Message.class);
    }

    @NotNull
    default public Preferences getPreferencesFromJson(@NotNull String json) throws JsonSyntaxException {
        return this.getGson().fromJson(json, Preferences.class);
    }
}

