/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.commands.TeamCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandPermission;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Subcommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Syntax;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Values;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.bukkit.contexts.OnlinePlayer;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.migrator.Migrator;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

@CommandAlias(value="teamadmin|ta")
public class TeamAdmin
extends BaseCommand {
    private final FileConfiguration messagesConfig;
    private static final String PLAYER_TO_KICK = "%KICKEDPLAYER%";
    private final UltimateTeams plugin;
    private Migrator migrator;

    public TeamAdmin(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    @Default
    @Subcommand(value="about")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.admin.about")
    public void aboutSubcommand(CommandSender sender) {
        sender.sendMessage(Utils.Color("&3~~~~~~~~~~ &6&nUltimateTeams&r &3~~~~~~~~~~"));
        sender.sendMessage(Utils.Color("&3Version: &6" + this.plugin.getDescription().getVersion()));
        sender.sendMessage(Utils.Color("&3Database Type: &6" + this.plugin.getSettings().getDatabaseType().getDisplayName()));
        this.plugin.getMessageBroker().ifPresent(broker -> sender.sendMessage(Utils.Color("&3Broker Type: &6" + this.plugin.getSettings().getBrokerType().getDisplayName())));
        sender.sendMessage(Utils.Color("&3Author: &6" + String.valueOf(this.plugin.getDescription().getAuthors())));
        sender.sendMessage(Utils.Color("&3Description: &6" + this.plugin.getDescription().getDescription()));
        sender.sendMessage(Utils.Color("&3Website: "));
        sender.sendMessage(Utils.Color("&6" + this.plugin.getDescription().getWebsite()));
        sender.sendMessage(Utils.Color("&3~~~~~~~~~~ &6&nUltimateTeams&r &3~~~~~~~~~~"));
    }

    @Subcommand(value="reload")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.admin.reload")
    public void reloadSubcommand(CommandSender sender) {
        sender.sendMessage(Utils.Color(this.messagesConfig.getString("plugin-reload-begin")));
        this.plugin.runSync(task -> {
            this.plugin.loadConfigs();
            this.plugin.msgFileManager.reloadMessagesConfig();
            TeamCommand.updateBannedTagsList();
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("plugin-reload-successful")));
        });
    }

    @Subcommand(value="migrate")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.admin.migrate")
    public void migrateSubcommand(CommandSender sender) {
        sender.sendMessage("Visit: https://github.com/xF3d33/UltimateTeams/blob/main/HowToMigrate.md for a guida on how to migrate");
    }

    @Subcommand(value="migrate set")
    @CommandCompletion(value="<parameter> <value>")
    @CommandPermission(value="ultimateteams.admin.migrate")
    public void migrateSetSubcommand(CommandSender sender, String parameter, String value) {
        this.migrator = new Migrator(this.plugin);
        this.migrator.setParameter(parameter, value);
        sender.sendMessage(Utils.Color(String.format("Parameter %s set to %s", parameter, value)));
    }

    @Subcommand(value="migrate start")
    @CommandCompletion(value="<parameter> <value>")
    @CommandPermission(value="ultimateteams.admin.migrate")
    public void migrateStartSubcommand(CommandSender sender) {
        if (this.migrator == null) {
            sender.sendMessage(Utils.Color("&3Set migrator's parameters first!"));
            return;
        }
        this.migrator.startMigration();
    }

    @Subcommand(value="team disband")
    @CommandCompletion(value="@teams")
    @CommandPermission(value="ultimateteams.admin.team.disband")
    @Syntax(value="<teamName>")
    public void disbandSubcommand(CommandSender sender, @Values(value="@teams") String teamName) {
        this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> {
            if (!this.plugin.getSettings().isEnableCrossServer()) {
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().deleteTeamData(null, (Team)team));
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-successfully-disbanded")));
                return;
            }
            Bukkit.getOnlinePlayers().stream().findAny().ifPresentOrElse(randomPlayer -> {
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().deleteTeamData((Player)randomPlayer, (Team)team));
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-successfully-disbanded")));
            }, () -> this.plugin.log(Level.WARNING, "No players online to send message to other servers", new Throwable[0]));
        }, () -> sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-admin-disband-failure"))));
    }

    @Subcommand(value="team join")
    @CommandCompletion(value="@players @teams @nothing")
    @CommandPermission(value="ultimateteams.admin.team.join")
    @Syntax(value="<Player> <teamName>")
    public void teamJoinSubCommand(CommandSender sender, OnlinePlayer user, @Values(value="@teams") String teamName) {
        Player player = user.getPlayer();
        if (this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).isPresent()) {
            String joinMessage = Utils.Color(this.messagesConfig.getString("team-invite-invited-already-in-team"));
            sender.sendMessage(joinMessage);
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> {
            this.plugin.getTeamStorageUtil().addTeamMember((Team)team, player);
            String joinMessage = Utils.Color(this.messagesConfig.getString("team-join-successful")).replace("%TEAM%", team.getName());
            sender.sendMessage(joinMessage);
            team.sendTeamMessage(Utils.Color(this.messagesConfig.getString("team-join-broadcast-chat").replace("%PLAYER%", player.getName()).replace("%TEAM%", Utils.Color(team.getName()))));
        }, () -> sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-join-failed")).replace("%TEAM%", teamName)));
    }

    @Subcommand(value="team transfer")
    @CommandCompletion(value="@teams @onlineUsers @nothing")
    @CommandPermission(value="ultimateteams.admin.team.transfer")
    @Syntax(value="<team> <player>")
    public void teamTransferSubCommand(CommandSender sender, @Values(value="@teams") String teamName, @Values(value="@onlineUsers") OfflinePlayer user) {
        if (!user.hasPlayedBefore() || user.getName() == null) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-not-found")));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> {
            if (!team.getMembers().containsKey(user.getUniqueId())) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-ownership-transfer-failure-not-same-team")));
                return;
            }
            this.plugin.getTeamStorageUtil().transferTeamOwner((Team)team, user.getUniqueId());
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-ownership-transfer-successful").replace("%PLAYER%", user.getName())));
            if (user.isOnline() && user.getPlayer() != null) {
                user.getPlayer().sendMessage(Utils.Color(this.messagesConfig.getString("team-ownership-transfer-new-owner").replace("%TEAM%", team.getName())));
            }
        }, () -> sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-not-found"))));
    }
}

