/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamRenameSubCommand {
    private final int MIN_CHAR_LIMIT;
    private final int MAX_CHAR_LIMIT;
    private static final String TEAM_PLACEHOLDER = "%TEAM%";
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public TeamRenameSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
        this.MIN_CHAR_LIMIT = plugin.getSettings().getTeamNameMinLength();
        this.MAX_CHAR_LIMIT = plugin.getSettings().getTeamNameMaxLength();
    }

    public void renameTeamSubCommand(CommandSender sender, String newname, List<String> bannedTags) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (newname.contains(" ")) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-name-contains-space").replace(TEAM_PLACEHOLDER, newname)));
            return;
        }
        if (bannedTags.stream().map(String::toLowerCase).toList().contains(newname.toLowerCase())) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-name-is-banned").replace(TEAM_PLACEHOLDER, newname)));
            return;
        }
        if (this.plugin.getTeamStorageUtil().getTeamsName().stream().map(String::toLowerCase).toList().contains(newname.toLowerCase())) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-name-already-taken").replace(TEAM_PLACEHOLDER, newname)));
            return;
        }
        if (!this.plugin.getSettings().isTeamCreateAllowColorCodes() && (newname.contains("&") || newname.contains("#"))) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-name-cannot-contain-colours")));
            return;
        }
        if (this.plugin.getSettings().isTeamCreateRequirePermColorCodes() && !player.hasPermission("ultimateteams.team.create.usecolors") && (newname.contains("&") || newname.contains("#"))) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("use-colours-missing-permission")));
            return;
        }
        int nameLength = Utils.removeColors(newname).length();
        if (nameLength < this.MIN_CHAR_LIMIT) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-name-too-short").replace("%CHARMIN%", Integer.toString(this.MIN_CHAR_LIMIT))));
            return;
        }
        if (nameLength > this.MAX_CHAR_LIMIT) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-name-too-long").replace("%CHARMAX%", Integer.toString(this.MAX_CHAR_LIMIT))));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RENAME))) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                return;
            }
            team.setName(newname);
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-name-change-successful")).replace(TEAM_PLACEHOLDER, newname));
        }, () -> sender.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }
}

