/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.home;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamHomePreTeleportEvent;
import dev.xf3d3.ultimateteams.api.events.TeamHomeTeleportEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamHome;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TeamHomeSubCommand {
    private final FileConfiguration messagesConfig;
    private static final String TIME_LEFT = "%TIMELEFT%";
    private static TeamHomePreTeleportEvent homePreTeleportEvent = null;
    private static final ConcurrentHashMap<UUID, Long> homeCoolDownTimer = new ConcurrentHashMap();
    private final UltimateTeams plugin;

    public TeamHomeSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    public void tpTeamHomeSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamHomeEnabled()) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            TeamHome home = team.getHome();
            if (home == null) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-no-home-set")));
                return;
            }
            this.fireTeamHomePreTPEvent(player, (Team)team);
            if (homePreTeleportEvent.isCancelled()) {
                if (this.plugin.getSettings().debugModeEnabled()) {
                    this.plugin.log(Level.INFO, Utils.Color("&6UltimateTeams-Debug: &aTeamHomePreTPEvent cancelled by external source"), new Throwable[0]);
                }
                return;
            }
            if (this.plugin.getSettings().teamHomeCooldownEnabled()) {
                if (!player.hasPermission("ultimateteams.bypass.homecooldown") && homeCoolDownTimer.containsKey(player.getUniqueId())) {
                    if (homeCoolDownTimer.get(player.getUniqueId()) > System.currentTimeMillis()) {
                        long timeLeft = (homeCoolDownTimer.get(player.getUniqueId()) - System.currentTimeMillis()) / 1000L;
                        player.sendMessage(Utils.Color(this.messagesConfig.getString("home-cool-down-timer-wait").replaceAll(TIME_LEFT, Long.toString(timeLeft))));
                    } else {
                        homeCoolDownTimer.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.plugin.getSettings().getTeamHomeCooldownValue() * 1000L);
                        this.fireTeamHomeTeleportEvent(player, (Team)team, home.getLocation(), player.getLocation());
                        this.tpHome(player, home);
                    }
                } else {
                    this.fireTeamHomeTeleportEvent(player, (Team)team, home.getLocation(), player.getLocation());
                    this.tpHome(player, home);
                    homeCoolDownTimer.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.plugin.getSettings().getTeamHomeCooldownValue() * 1000L);
                }
                return;
            }
            this.fireTeamHomeTeleportEvent(player, (Team)team, home.getLocation(), player.getLocation());
            this.tpHome(player, home);
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-tp-not-in-team"))));
    }

    private void tpHome(@NotNull Player player, @NotNull TeamHome home) {
        this.plugin.getUtils().teleportPlayer(player, home.getLocation(), home.getServer(), Utils.TeleportType.HOME, null);
    }

    private void fireTeamHomePreTPEvent(Player player, Team team) {
        TeamHomePreTeleportEvent teamHomePreTeleportEvent = new TeamHomePreTeleportEvent(player, team);
        Bukkit.getPluginManager().callEvent((Event)teamHomePreTeleportEvent);
        homePreTeleportEvent = teamHomePreTeleportEvent;
    }

    private void fireTeamHomeTeleportEvent(Player player, Team team, Location homeLocation, Location tpFromLocation) {
        TeamHomeTeleportEvent teamHomeTeleportEvent = new TeamHomeTeleportEvent(player, team, homeLocation, tpFromLocation);
        Bukkit.getPluginManager().callEvent((Event)teamHomeTeleportEvent);
    }
}

