/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamKickSubCommand {
    FileConfiguration messagesConfig;
    private static final String TEAM_PLACEHOLDER = "%TEAM%";
    private static final String PLAYER_TO_KICK = "%KICKEDPLAYER%";
    private final UltimateTeams plugin;

    public TeamKickSubCommand(@NotNull UltimateTeams plugin) {
        this.messagesConfig = UltimateTeams.getPlugin().msgFileManager.getMessagesConfig();
        this.plugin = plugin;
    }

    public void teamKickSubCommand(CommandSender sender, OfflinePlayer offlinePlayer) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!offlinePlayer.hasPlayedBefore()) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("could-not-find-specified-player").replace(PLAYER_TO_KICK, offlinePlayer.toString())));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.KICK))) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                return;
            }
            if (player.getName().equalsIgnoreCase(offlinePlayer.getName())) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-cannot-kick-yourself")));
                return;
            }
            if (!team.getMembers().containsKey(offlinePlayer.getUniqueId())) {
                String differentTeamMessage = Utils.Color(this.messagesConfig.getString("targeted-player-is-not-in-your-team")).replace(PLAYER_TO_KICK, offlinePlayer.getName());
                player.sendMessage(differentTeamMessage);
            }
            this.plugin.getTeamStorageUtil().kickPlayer(player, (Team)team, offlinePlayer);
            String playerKickedMessage = Utils.Color(this.messagesConfig.getString("team-member-kick-successful")).replace(PLAYER_TO_KICK, offlinePlayer.getName());
            player.sendMessage(playerKickedMessage);
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }
}

