/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.relations;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamAllyAddEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.TeamsStorage;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Optional;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TeamAllySubCommand {
    private final FileConfiguration messagesConfig;
    private final Logger logger;
    private static final String ALLY_TEAM = "%ALLYTEAM%";
    private static final String ALLY_OWNER = "%ALLYTEAM%";
    private static final String TEAM_OWNER = "%TEAMOWNER%";
    private final UltimateTeams plugin;

    public TeamAllySubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
        this.logger = plugin.getLogger();
    }

    public void teamAllyAddSubCommand(CommandSender sender, String teamName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RELATIONS))) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                return;
            }
            if (team.getRelations(this.plugin).size() >= this.plugin.getSettings().getMaxTeamAllies()) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("team-ally-max-amount-reached")).replaceAll("%LIMIT%", String.valueOf(this.plugin.getSettings().getMaxTeamAllies())));
                return;
            }
            Optional<Team> optionalOtherTeam = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
            if (optionalOtherTeam.isEmpty() || optionalOtherTeam.get().equals(team)) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("team-not-found")));
                return;
            }
            Team otherTeam = optionalOtherTeam.get();
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ENEMY)) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-cannot-ally-enemy-team")));
                return;
            }
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ALLY)) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-team-already-your-ally")));
                return;
            }
            this.plugin.getTeamStorageUtil().addTeamAlly((Team)team, otherTeam, player);
            team.sendTeamMessage(Utils.Color(this.messagesConfig.getString("added-team-to-your-allies").replaceAll("%ALLYTEAM%", otherTeam.getName())));
            otherTeam.sendTeamMessage(Utils.Color(this.messagesConfig.getString("team-added-to-other-allies").replaceAll(TEAM_OWNER, team.getName())));
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }

    public void teamAllyRemoveSubCommand(CommandSender sender, String teamName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RELATIONS))) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                return;
            }
            Optional<Team> optionalOtherTeam = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
            if (optionalOtherTeam.isEmpty() || optionalOtherTeam.get().equals(team)) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("team-not-found")));
                return;
            }
            Team otherTeam = optionalOtherTeam.get();
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ALLY)) {
                this.plugin.getTeamStorageUtil().removeTeamAlly((Team)team, otherTeam, player);
                team.sendTeamMessage(Utils.Color(this.messagesConfig.getString("removed-team-from-your-allies").replace("%ALLYTEAM%", otherTeam.getName())));
                otherTeam.sendTeamMessage(Utils.Color(this.messagesConfig.getString("team-removed-from-other-allies").replace("%ALLYTEAM%", team.getName())));
            } else {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-to-remove-team-from-allies").replace("%ALLYTEAM%", teamName)));
            }
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }

    private void fireTeamAllyRemoveEvent(TeamsStorage storageUtil, Player player, Player allyTeamOwner, Team allyTeam) {
    }

    private void fireTeamAllyAddEvent(Player player, Team team, Player allyTeamOwner, Team allyTeam) {
        TeamAllyAddEvent teamAllyAddEvent = new TeamAllyAddEvent(player, team, allyTeam, allyTeamOwner);
        Bukkit.getPluginManager().callEvent((Event)teamAllyAddEvent);
    }
}

