/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.relations;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamEnemyAddEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.TeamsStorage;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TeamEnemySubCommand {
    private static final String ENEMY_Team = "%ENEMYTEAM%";
    private static final String ENEMY_OWNER = "%ENEMYOWNER%";
    private static final String Team_OWNER = "%TEAMOWNER%";
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public TeamEnemySubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    public void teamEnemySubAddCommand(CommandSender sender, String teamName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RELATIONS))) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                return;
            }
            if (team.getRelations(this.plugin).size() >= this.plugin.getSettings().getMaxTeamEnemies()) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("team-enemy-max-amount-reached")).replaceAll("%LIMIT%", String.valueOf(this.plugin.getSettings().getMaxTeamAllies())));
                return;
            }
            Optional<Team> optionalOtherTeam = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
            if (optionalOtherTeam.isEmpty() || optionalOtherTeam.get().equals(team)) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("team-not-found")));
                return;
            }
            Team otherTeam = optionalOtherTeam.get();
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ALLY)) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-cannot-enemy-allied-team")));
                return;
            }
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ENEMY)) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-team-already-your-enemy")));
                return;
            }
            this.plugin.getTeamStorageUtil().addTeamEnemy((Team)team, otherTeam, player);
            team.sendTeamMessage(Utils.Color(this.messagesConfig.getString("added-team-to-your-enemies").replaceAll(ENEMY_Team, otherTeam.getName())));
            otherTeam.sendTeamMessage(Utils.Color(this.messagesConfig.getString("team-added-to-other-enemies").replaceAll(Team_OWNER, team.getName())));
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }

    public void teamEnemySubRemoveCommand(CommandSender sender, String teamName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RELATIONS))) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                return;
            }
            Optional<Team> optionalOtherTeam = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
            if (optionalOtherTeam.isEmpty() || optionalOtherTeam.get().equals(team)) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("team-not-found")));
                return;
            }
            Team otherTeam = optionalOtherTeam.get();
            if (team.getRelations(this.plugin).containsKey(otherTeam) && team.getRelations(this.plugin).get(otherTeam).equals((Object)Team.Relation.ENEMY)) {
                this.plugin.getTeamStorageUtil().removeTeamEnemy((Team)team, otherTeam, player);
                team.sendTeamMessage(Utils.Color(this.messagesConfig.getString("removed-team-from-your-enemies").replace(ENEMY_Team, otherTeam.getName())));
                otherTeam.sendTeamMessage(Utils.Color(this.messagesConfig.getString("team-removed-from-other-enemies").replace(Team_OWNER, team.getName())));
            } else {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-to-remove-team-from-enemies").replace(ENEMY_Team, teamName)));
            }
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }

    private void fireTeamEnemyRemoveEvent(TeamsStorage storageUtil, Player player, Player enemyTeamOwner, Team enemyTeam) {
    }

    private void fireTeamEnemyAddEvent(Player player, Team team, Player enemyTeamOwner, Team enemyTeam) {
        TeamEnemyAddEvent teamEnemyAddEvent = new TeamEnemyAddEvent(player, team, enemyTeam, enemyTeamOwner);
        Bukkit.getPluginManager().callEvent((Event)teamEnemyAddEvent);
    }
}

