/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.config;

import dev.xf3d3.ultimateteams.UltimateTeams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessagesFileManager {
    private final UltimateTeams plugin;
    private FileConfiguration dataConfig = null;
    private File configFile = null;

    public MessagesFileManager(UltimateTeams plugin) {
        this.plugin = plugin;
        this.saveDefaultMessagesConfig();
    }

    public void reloadMessagesConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream defaultStream = this.plugin.getResource("messages.yml");
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.dataConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public FileConfiguration getMessagesConfig() {
        if (this.dataConfig == null) {
            this.reloadMessagesConfig();
        }
        return this.dataConfig;
    }

    public void saveMessagesConfig() {
        if (this.dataConfig == null || this.configFile == null) {
            return;
        }
        try {
            this.getMessagesConfig().save(this.configFile);
        }
        catch (IOException ex) {
            this.plugin.log(Level.SEVERE, "UltimateTeams: Could not save messages.yml", new Throwable[0]);
            this.plugin.log(Level.SEVERE, "UltimateTeams: Check the below message for the reasons!", ex);
        }
    }

    public void saveDefaultMessagesConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
    }
}

