/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.gui;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.gui.TeamManager;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.DynamicGuiElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiElementGroup;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiPageElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.InventoryGui;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamWarp;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Optional;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WarpsManager {
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;
    private final Player player;

    public WarpsManager(@NotNull UltimateTeams plugin, @NotNull Player player) {
        this.messagesConfig = UltimateTeams.getPlugin().msgFileManager.getMessagesConfig();
        this.plugin = plugin;
        this.player = player;
        this.open();
    }

    private void open() {
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, (InventoryHolder)this.player, Utils.Color(this.plugin.getTeamsGui().getWarpsManagerGuiName()), this.plugin.getTeamsGui().getTeamsManagerWarpsguiSetup().toArray(new String[0]), new GuiElement[0]);
        gui.addElement(new GuiPageElement('f', new ItemStack(this.plugin.getTeamsGui().getPreviousPageMaterial()), GuiPageElement.PageAction.PREVIOUS, this.plugin.getTeamsGui().getPreviousPage()));
        gui.addElement(new GuiPageElement('n', new ItemStack(this.plugin.getTeamsGui().getNextPageMaterial()), GuiPageElement.PageAction.NEXT, this.plugin.getTeamsGui().getNextPage()));
        gui.addElement(new StaticGuiElement('b', new ItemStack(this.plugin.getTeamsGui().getBackButtonMaterial()), 1, click -> {
            click.getGui().close();
            new TeamManager(this.plugin, this.player);
            return true;
        }, this.plugin.getTeamsGui().getBackButtonName()));
        GuiElementGroup group = new GuiElementGroup('g', new GuiElement[0]);
        Optional<Team> OptionalTeam = this.plugin.getTeamStorageUtil().findTeamByMember(this.player.getUniqueId());
        if (OptionalTeam.isEmpty()) {
            throw new IllegalStateException("Team not found");
        }
        Team team = OptionalTeam.get();
        for (TeamWarp warp : team.getWarps().values()) {
            group.addElement(new DynamicGuiElement('g', viewer -> new StaticGuiElement('g', new ItemStack(this.plugin.getTeamsGui().getTeamsManagerGuiWarpsMaterial()), 1, click -> {
                if (click.getType().isLeftClick()) {
                    this.plugin.getUtils().teleportPlayer(this.player, warp.getLocation(), warp.getServer() == null ? null : warp.getServer(), Utils.TeleportType.WARP, warp.getName());
                    click.getGui().close();
                }
                if (click.getType().isRightClick()) {
                    if (this.plugin.getTeamStorageUtil().isTeamOwner(this.player) || this.plugin.getTeamStorageUtil().isTeamManager(this.player) && team.hasPermission(Team.Permission.WARPS)) {
                        team.removeTeamWarp(warp.getName());
                        this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(this.player, team));
                        this.player.sendMessage(Utils.Color(this.messagesConfig.getString("team-warp-deleted-successful").replaceAll("%WARP_NAME%", warp.getName())));
                        click.getGui().close();
                        new WarpsManager(this.plugin, this.player);
                    } else {
                        this.player.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                    }
                }
                return true;
            }, (String[])this.plugin.getTeamsGui().getWarpsManagerGuiWarpsText().stream().map(s -> s.replaceAll("%WARP%", warp.getName())).toArray(String[]::new))));
        }
        gui.addElement(group);
        gui.show((HumanEntity)this.player);
    }
}

