/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.listeners;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamFriendlyFireAttackEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.projectiles.ProjectileSource;

public class PlayerDamageEvent
implements Listener {
    FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public PlayerDamageEvent(@NotNull UltimateTeams plugin) {
        this.messagesConfig = UltimateTeams.getPlugin().msgFileManager.getMessagesConfig();
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Player attackingPlayer = null;
        if (e.getDamager() instanceof Player) {
            attackingPlayer = (Player)e.getDamager();
        } else {
            Entity entity2 = e.getDamager();
            if (entity2 instanceof Projectile) {
                Projectile projectile = (Projectile)entity2;
                ProjectileSource projectileSource = projectile.getShooter();
                if (projectileSource instanceof Player) {
                    shooter = (Player)projectileSource;
                    attackingPlayer = shooter;
                }
            } else {
                shooter = e.getDamager();
                if (shooter instanceof Firework) {
                    Firework firework = (Firework)shooter;
                    ProjectileSource projectileSource = firework.getShooter();
                    if (projectileSource instanceof Player) {
                        shooter = (Player)projectileSource;
                        attackingPlayer = shooter;
                    }
                } else {
                    TNTPrimed tntPrimed;
                    Entity entity3;
                    shooter = e.getDamager();
                    if (shooter instanceof TNTPrimed && (entity3 = (tntPrimed = (TNTPrimed)shooter).getSource()) instanceof Player) {
                        shooter = (Player)entity3;
                        attackingPlayer = shooter;
                    }
                }
            }
        }
        if (attackingPlayer == null) {
            return;
        }
        if (attackingPlayer.getUniqueId() == victim.getUniqueId()) {
            return;
        }
        Team attackerTeam = this.plugin.getTeamStorageUtil().findTeamByMember(attackingPlayer.getUniqueId()).orElse(null);
        Team victimTeam = this.plugin.getTeamStorageUtil().findTeamByMember(victim.getUniqueId()).orElse(null);
        if (attackerTeam == null || victimTeam == null || attackingPlayer.hasPermission("ultimateteams.bypass.pvp") && this.plugin.getSettings().enablePvPBypassPermission()) {
            return;
        }
        if (attackerTeam.equals(victimTeam) && attackerTeam.isFriendlyFire()) {
            return;
        }
        if (attackerTeam.areRelationsBilateral(victimTeam, Team.Relation.ALLY)) {
            e.setCancelled(true);
            attackingPlayer.sendMessage(Utils.Color(this.messagesConfig.getString("friendly-fire-is-disabled-for-allies")));
        }
    }

    private void fireClanFriendlyFireAttackEvent(Player createdBy, Player attackingPlayer, Player victimPlayer, Team attackingTeam, Team victimTeam) {
        TeamFriendlyFireAttackEvent teamFriendlyFireAttackEvent = new TeamFriendlyFireAttackEvent(createdBy, attackingPlayer, victimPlayer, attackingTeam, victimTeam);
        Bukkit.getPluginManager().callEvent((Event)teamFriendlyFireAttackEvent);
    }
}

