/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.migrator;

import com.google.common.collect.Maps;
import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.commands.TeamCommand;
import dev.xf3d3.ultimateteams.database.Database;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.migrator.legacyModels.LegacyTeam;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamHome;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import dev.xf3d3.ultimateteams.models.TeamWarp;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class Migrator {
    private final UltimateTeams plugin;
    private final TreeMap<String, String> parameters;

    public Migrator(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.parameters = new TreeMap();
    }

    public void startMigration() {
        this.plugin.setLoaded(false);
        this.plugin.runAsync(task -> {
            try {
                this.plugin.log(Level.INFO, "Migration started...", new Throwable[0]);
                this.plugin.getTeamStorageUtil().getTeams().clear();
                this.plugin.getDatabase().deleteAllTeams();
                this.plugin.log(Level.INFO, "Migrating teams...", new Throwable[0]);
                this.getConvertedTeams().forEach(team -> {
                    try {
                        team.setId(this.plugin.getDatabase().createTeam((Team)team).getId());
                        this.plugin.getTeamStorageUtil().getTeams().add((Team)team);
                    }
                    catch (IllegalStateException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Failed to migrate team " + team.getName(), e.getMessage());
                    }
                });
                this.plugin.log(Level.INFO, "Migrating users (this may take some time)...", new Throwable[0]);
                this.plugin.getDatabase().deleteAllUsers();
                this.getConvertedUsers().forEach(teamPlayer -> {
                    try {
                        this.plugin.getDatabase().createPlayer((TeamPlayer)teamPlayer);
                    }
                    catch (IllegalStateException e) {
                        this.plugin.log(Level.SEVERE, "Failed to migrate user " + teamPlayer.getLastPlayerName(), e.getCause());
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to migrate", e.getMessage());
            }
            finally {
                this.plugin.log(Level.INFO, "Migration ended successfully.", new Throwable[0]);
                this.plugin.loadConfigs();
                this.plugin.msgFileManager.reloadMessagesConfig();
                TeamCommand.updateBannedTagsList();
                this.plugin.getTeamStorageUtil().loadTeams();
                this.plugin.runSync(t -> this.plugin.setLoaded(true));
            }
        });
    }

    @NotNull
    private List<Team> getConvertedTeams() {
        ArrayList<Team> teams = new ArrayList<Team>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatement("SELECT * FROM %teams%"));
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String data = new String(resultSet.getBytes("data"), StandardCharsets.UTF_8);
                LegacyTeam team = this.plugin.getGson().fromJson(data, LegacyTeam.class);
                HashMap members = Maps.newHashMap();
                members.put(UUID.fromString(team.getTeamOwner()), 3);
                team.getTeamMembers().forEach(member -> members.put(UUID.fromString(member), 1));
                HashMap warps = Maps.newHashMap();
                team.getTeamWarps().forEach(legacyWarp -> warps.put(legacyWarp.getName(), TeamWarp.of(legacyWarp.getName(), legacyWarp.getLocation(), this.plugin.getSettings().isEnableCrossServer() ? this.plugin.getSettings().getServerName() : null)));
                TeamHome teamHome = null;
                if (team.getTeamHomeWorld() != null) {
                    Location homeLocation = new Location(Bukkit.getWorld((String)team.getTeamHomeWorld()), team.getTeamHomeX(), team.getTeamHomeY(), team.getTeamHomeZ(), team.getTeamHomeYaw(), team.getTeamHomePitch());
                    teamHome = TeamHome.of(homeLocation, this.plugin.getSettings().getServerName());
                }
                teams.add(Team.builder().name(team.getTeamFinalName()).friendlyFire(team.isFriendlyFireAllowed()).prefix(team.getTeamPrefix()).members(members).home(teamHome).warps(warps).build());
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return teams;
    }

    private List<TeamPlayer> getConvertedUsers() {
        ArrayList<TeamPlayer> teamPlayers = new ArrayList<TeamPlayer>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.formatStatement("SELECT * FROM %players%"));
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                teamPlayers.add(new TeamPlayer(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username"), resultSet.getBoolean("isBedrock"), resultSet.getString("bedrockUUID"), null));
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return teamPlayers;
    }

    @NotNull
    private Connection getConnection() throws SQLException {
        Database.Type type = this.getParameter(Parameters.DATABASE_TYPE.name()).map(String::toUpperCase).map(Database.Type::valueOf).orElse(Database.Type.MYSQL);
        String host = this.getParameter(Parameters.DATABASE_HOST.name()).orElse("localhost");
        int port = this.getParameter(Parameters.DATABASE_PORT.name()).map(Integer::parseInt).orElse(3306);
        String database = this.getParameter(Parameters.DATABASE_NAME.name()).orElse("ultimateteams");
        String username = this.getParameter(Parameters.DATABASE_USERNAME.name()).orElse("root");
        String password = this.getParameter(Parameters.DATABASE_PASSWORD.name()).orElse("");
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Database.Type.MYSQL -> DriverManager.getConnection("jdbc:mysql://" + host + ":" + port + "/" + database, username, password);
            case Database.Type.SQLITE -> DriverManager.getConnection("jdbc:sqlite:" + new File(this.plugin.getDataFolder(), "LegacyUltimateTeamsData.db").getAbsolutePath());
            case Database.Type.H2 -> DriverManager.getConnection("jdbc:h2:" + new File(this.plugin.getDataFolder(), "LegacyUltimateTeamsData").getAbsolutePath());
            case Database.Type.MARIADB -> DriverManager.getConnection("jdbc:mariadb://" + host + ":" + port + "/" + database, username, password);
            case Database.Type.POSTGRESQL -> DriverManager.getConnection("jdbc:postgresql://" + host + ":" + port + "/" + database, username, password);
        };
    }

    @NotNull
    public TreeMap<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameter(@NotNull String key, @NotNull String value) {
        this.parameters.put(key.toUpperCase(), value);
    }

    public Optional<String> getParameter(@NotNull String key) {
        return Optional.ofNullable(this.getParameters().get(key));
    }

    @NotNull
    private String formatStatement(@NotNull String statement) {
        return statement.replaceAll("%players%", this.getParameter(Parameters.PLAYERS_TABLE.name()).orElse("ultimateteams_users")).replaceAll("%teams%", this.getParameter(Parameters.TEAMS_TABLE.name()).orElse("ultimateteams_teams"));
    }

    private static enum Parameters {
        DATABASE_TYPE("MySQL"),
        DATABASE_HOST("localhost"),
        DATABASE_PORT("3306"),
        DATABASE_NAME("ultimateteams"),
        DATABASE_USERNAME("root"),
        DATABASE_PASSWORD("pa55w0rd"),
        PLAYERS_TABLE("ultimateteams_users"),
        TEAMS_TABLE("ultimateteams_teams");

        private final String defaultValue;

        private Parameters(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @NotNull
        private String getDefault() {
            return this.defaultValue;
        }
    }
}

