/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.network;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.network.MessageHandler;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.entity.Player;

public abstract class Broker
implements MessageHandler {
    protected final UltimateTeams plugin;

    protected Broker(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    protected void handle(@Nullable Player receiver, @NotNull Message message) {
        if (message.getSourceServer().equals(this.getServer())) {
            return;
        }
        switch (message.getType()) {
            case REQUEST_USER_LIST: {
                this.handleRequestUserList(message, receiver);
                break;
            }
            case UPDATE_USER_LIST: {
                this.handleUpdateUserList(message);
                break;
            }
            case TEAM_DELETE: {
                this.handleTeamDelete(message);
                break;
            }
            case TEAM_UPDATE: {
                this.handleTeamUpdate(message);
                break;
            }
            case TEAM_TRANSFERRED: {
                this.handleTeamAction(message);
                break;
            }
            case TEAM_EVICTED: {
                this.handleTeamUserAction(message, receiver);
                break;
            }
            case TEAM_INVITE_REQUEST: {
                this.handleTeamInviteRequest(message, receiver);
                break;
            }
            case TEAM_INVITE_REPLY: {
                this.handleTeamInviteReply(message, receiver);
                break;
            }
            case TEAM_CHAT_MESSAGE: {
                this.handleTeamChatMessage(message);
                break;
            }
            case TEAM_ALLY_CHAT_MESSAGE: {
                this.handleTeamAllyChatMessage(message);
                break;
            }
            default: {
                this.plugin.log(Level.SEVERE, "Received unknown message type: " + String.valueOf((Object)message.getType()), new Throwable[0]);
            }
        }
    }

    public abstract void initialize() throws RuntimeException;

    public abstract void changeServer(@NotNull Player var1, @NotNull String var2);

    protected abstract void send(@NotNull Message var1, @NotNull Player var2);

    public abstract void close();

    @NotNull
    protected String getSubChannelId() {
        return String.valueOf(this.plugin.getSettings().getClusterId());
    }

    protected String getServer() {
        return this.plugin.getSettings().getServerName();
    }

    @NotNull
    private String getFormattedVersion() {
        return String.format("%s.%s", this.plugin.getPluginVersion().getMajor(), this.plugin.getPluginVersion().getMinor());
    }

    @Override
    @NotNull
    public Broker getBroker() {
        return this;
    }

    @Override
    @Generated
    public UltimateTeams getPlugin() {
        return this.plugin;
    }

    public static enum Type {
        PLUGIN_MESSAGE("Plugin Messages"),
        REDIS("Redis");

        @NotNull
        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        @Generated
        public String getDisplayName() {
            return this.displayName;
        }
    }
}

