/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.network;

import dev.xf3d3.ultimateteams.libraries.gson.annotations.Expose;
import dev.xf3d3.ultimateteams.libraries.gson.annotations.SerializedName;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.network.Broker;
import dev.xf3d3.ultimateteams.network.Payload;
import lombok.Generated;
import org.bukkit.entity.Player;

public class Message {
    public static final String TARGET_ALL = "ALL";
    @Expose
    @NotNull
    private Type type;
    @Expose
    @SerializedName(value="target_type")
    @NotNull
    private TargetType targetType;
    @Expose
    @NotNull
    private String target;
    @Expose
    @NotNull
    private Payload payload;
    @Expose
    @NotNull
    private String sender;
    @Expose
    @NotNull
    private String sourceServer;

    private Message(@NotNull Type type, @NotNull String target, @NotNull TargetType targetType, @NotNull Payload payload) {
        this.type = type;
        this.target = target;
        this.payload = payload;
        this.targetType = targetType;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public void send(@NotNull Broker broker, @NotNull Player sender) {
        this.sender = sender.getName();
        this.sourceServer = broker.getServer();
        broker.send(this, sender);
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @NotNull
    public String getTarget() {
        return this.target;
    }

    @NotNull
    public TargetType getTargetType() {
        return this.targetType;
    }

    @NotNull
    public Payload getPayload() {
        return this.payload;
    }

    @NotNull
    public String getSender() {
        return this.sender;
    }

    @NotNull
    public String getSourceServer() {
        return this.sourceServer;
    }

    @Generated
    private Message() {
    }

    public static enum Type {
        TEAM_UPDATE,
        TEAM_DELETE,
        TEAM_INVITE_REQUEST,
        TEAM_INVITE_REPLY,
        TEAM_TRANSFERRED,
        TEAM_EVICTED,
        TEAM_RENAMED,
        TEAM_CHAT_MESSAGE,
        TEAM_ALLY_CHAT_MESSAGE,
        REQUEST_USER_LIST,
        UPDATE_USER_LIST;

    }

    public static enum TargetType {
        SERVER("Forward"),
        PLAYER("ForwardToPlayer");

        private final String pluginMessageChannel;

        @Generated
        private TargetType(String pluginMessageChannel) {
            this.pluginMessageChannel = pluginMessageChannel;
        }

        @Generated
        public String getPluginMessageChannel() {
            return this.pluginMessageChannel;
        }
    }

    public static class Builder {
        private Type type;
        private Payload payload = Payload.empty();
        private TargetType targetType = TargetType.PLAYER;
        private String target;

        private Builder() {
        }

        @NotNull
        public Builder type(@NotNull Type type) {
            this.type = type;
            return this;
        }

        @NotNull
        public Builder payload(@NotNull Payload payload) {
            this.payload = payload;
            return this;
        }

        @NotNull
        public Builder target(@NotNull String target, @NotNull TargetType targetType) {
            this.target = target;
            this.targetType = targetType;
            return this;
        }

        @NotNull
        public Message build() {
            return new Message(this.type, this.target, this.targetType, this.payload);
        }
    }
}

