/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.utils;

import com.google.common.collect.Sets;
import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import dev.xf3d3.ultimateteams.network.Broker;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.network.Payload;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamsStorage {
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)&[0-9A-FK-OR]");
    private final Set<Team> teams = Sets.newConcurrentHashSet();
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public TeamsStorage(@NotNull UltimateTeams plugin) {
        this.messagesConfig = UltimateTeams.getPlugin().msgFileManager.getMessagesConfig();
        this.plugin = plugin;
    }

    public void loadTeams() {
        this.teams.addAll(this.plugin.getDatabase().getAllTeams());
        this.plugin.sendConsole(Utils.Color("&eLoaded " + this.teams.size() + " teams!"));
        this.plugin.setLoaded(true);
    }

    public Collection<String> getTeamsName() {
        return this.teams.stream().map(Team::getName).sorted().toList();
    }

    public void removeTeam(@NotNull Team team) {
        this.teams.removeIf(t -> t.getId() == team.getId());
    }

    public void updateTeamLocal(@NotNull Team team) {
        this.removeTeam(team);
        this.teams.add(team);
    }

    public void updateTeamLocal(Team team, Integer id) {
        this.teams.removeIf(team1 -> team1.getId() == id.intValue());
        this.teams.add(team);
    }

    public void createTeam(Player player, String teamName) {
        this.plugin.runAsync(task -> {
            Team team = this.plugin.getDatabase().createTeam(teamName, player);
            this.teams.add(team);
            this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_UPDATE).payload(Payload.integer(team.getId())).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, player));
        });
    }

    public void updateTeamData(@NotNull Player actor, @NotNull Team team) {
        this.updateTeamLocal(team);
        this.plugin.getDatabase().updateTeam(team);
        this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_UPDATE).payload(Payload.integer(team.getId())).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, actor));
    }

    public void deleteTeamData(@Nullable Player player, @NotNull Team team) {
        this.plugin.getDatabase().deleteTeam(team.getId());
        this.removeTeam(team);
        if (player != null) {
            this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_DELETE).payload(Payload.integer(team.getId())).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, player));
        }
    }

    public boolean isInTeam(Player player) {
        return this.teams.stream().anyMatch(team -> team.getMembers().containsKey(player.getUniqueId()));
    }

    public boolean isTeamOwner(Player player) {
        return this.teams.stream().anyMatch(team -> team.getOwner().equals(player.getUniqueId()));
    }

    public boolean isTeamManager(Player player) {
        return this.teams.stream().anyMatch(team -> team.getMembers().getOrDefault(player.getUniqueId(), 0) == 2);
    }

    public Optional<Team> findTeam(int id) {
        return this.teams.stream().filter(team -> team.getId() == id).findFirst();
    }

    public Optional<Team> findTeamByName(String name) {
        return this.teams.stream().filter(team -> Utils.removeColors(team.getName()).equalsIgnoreCase(Utils.removeColors(name))).findFirst();
    }

    public Optional<Team> findTeamByOwner(UUID ownerUUID) {
        return this.teams.stream().filter(team -> team.getOwner().equals(ownerUUID)).findFirst();
    }

    public Optional<Team> findTeamByMember(UUID memberUUID) {
        return this.teams.stream().filter(team -> team.getMembers().containsKey(memberUUID)).findFirst();
    }

    public void addTeamMember(Team team, Player player) {
        team.addMember(player.getUniqueId(), null);
        this.plugin.runAsync(task -> this.updateTeamData(player, team));
    }

    public void addTeamEnemy(Team team, Team otherTeam, Player player) {
        team.setRelationWith(otherTeam, Team.Relation.ENEMY);
        this.plugin.runAsync(task -> this.updateTeamData(player, team));
    }

    public void removeTeamEnemy(Team team, Team otherTeam, Player player) {
        team.removeRelationWith(otherTeam);
        this.plugin.runAsync(task -> this.updateTeamData(player, team));
    }

    public void addTeamAlly(Team team, Team otherTeam, Player player) {
        team.setRelationWith(otherTeam, Team.Relation.ALLY);
        this.plugin.runAsync(task -> this.updateTeamData(player, team));
    }

    public void removeTeamAlly(Team team, Team otherTeam, Player player) {
        team.removeRelationWith(otherTeam);
        this.plugin.runAsync(task -> this.updateTeamData(player, team));
    }

    public boolean isHomeSet(Team team) {
        return team.getHome() != null;
    }

    public void deleteHome(Player player, Team team) {
        team.setHome(null);
        this.plugin.runAsync(task -> this.updateTeamData(player, team));
    }

    public void kickPlayer(Player teamOwner, Team team, OfflinePlayer player) {
        String name = Objects.requireNonNullElse(player.getName(), "");
        team.removeMember(player.getUniqueId());
        this.plugin.getUsersStorageUtil().getOnlineUsers().stream().filter(online -> online.getUniqueId().equals(player.getUniqueId())).findFirst().ifPresentOrElse(onlineUser -> {
            onlineUser.sendMessage(Utils.Color(this.messagesConfig.getString("team-kicked-player-message")).replace("%TEAM%", team.getName()));
            this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAcceptAsync(teamPlayer -> {
                if (teamPlayer.getPreferences().isTeamChatTalking()) {
                    teamPlayer.getPreferences().setTeamChatTalking(false);
                    this.plugin.getDatabase().updatePlayer((TeamPlayer)teamPlayer);
                }
            });
        }, () -> this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_EVICTED).target(name, Message.TargetType.PLAYER).build().send((Broker)broker, teamOwner)));
        this.plugin.runAsync(task -> this.updateTeamData(teamOwner, team));
    }

    public void transferTeamOwner(Team team, UUID newOwnerUUID) {
        team.getMembers().put(team.getOwner(), 1);
        team.getMembers().put(newOwnerUUID, 3);
        Player randomPlayer = Bukkit.getOnlinePlayers().stream().findFirst().orElse(null);
        if (randomPlayer == null) {
            return;
        }
        this.plugin.runAsync(task -> {
            this.updateTeamData(randomPlayer, team);
            this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_TRANSFERRED).payload(Payload.integer(team.getId())).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, randomPlayer));
        });
    }

    @Generated
    public Set<Team> getTeams() {
        return this.teams;
    }
}

