/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.utils;

import com.google.common.collect.Maps;
import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamChatSpyToggledEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Preferences;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import dev.xf3d3.ultimateteams.models.User;
import dev.xf3d3.ultimateteams.network.Broker;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.network.Payload;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class UsersStorage {
    private final Map<UUID, TeamPlayer> usermap = new ConcurrentHashMap<UUID, TeamPlayer>();
    private final UltimateTeams plugin;
    private final Map<String, List<User>> globalUserList = Maps.newConcurrentMap();
    private final ConcurrentMap<UUID, Player> onlineUserMap = Maps.newConcurrentMap();
    private final ConcurrentMap<UUID, Boolean> chatPlayers = Maps.newConcurrentMap();

    public UsersStorage(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public List<User> getUserList() {
        return Stream.concat(this.globalUserList.values().stream().flatMap(Collection::stream), this.onlineUserMap.values().stream().map(player -> User.of(player.getUniqueId(), player.getName()))).distinct().sorted().toList();
    }

    public Collection<Player> getOnlineUsers() {
        return this.getOnlineUserMap().values();
    }

    public Optional<Player> findOnlinePlayer(@NotNull String username) {
        return this.onlineUserMap.values().stream().filter(online -> online.getName().equalsIgnoreCase(username)).findFirst();
    }

    public void setUserList(@NotNull String server, @NotNull List<User> players) {
        this.globalUserList.values().forEach(list -> {
            list.removeAll(players);
            list.removeAll(this.onlineUserMap.values().stream().map(player -> User.of(player.getUniqueId(), player.getName())).toList());
        });
        this.globalUserList.put(server, players);
    }

    public void syncGlobalUserList(@NotNull Player user, @NotNull List<User> onlineUsers) {
        Optional<Broker> optionalBroker = this.plugin.getMessageBroker();
        if (optionalBroker.isEmpty()) {
            return;
        }
        Broker broker = optionalBroker.get();
        Message.builder().type(Message.Type.UPDATE_USER_LIST).target("ALL", Message.TargetType.SERVER).payload(Payload.userList(onlineUsers)).build().send(broker, user);
        if (this.onlineUserMap.size() == 1) {
            this.globalUserList.clear();
            Message.builder().type(Message.Type.REQUEST_USER_LIST).target("ALL", Message.TargetType.SERVER).build().send(broker, user);
        }
    }

    public void removePlayer(UUID uuid) {
        this.usermap.remove(uuid);
    }

    public CompletableFuture<TeamPlayer> getPlayer(UUID uuid) {
        if (this.usermap.containsKey(uuid)) {
            return CompletableFuture.completedFuture(this.usermap.get(uuid));
        }
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getPlayer(uuid).map(teamPlayer -> {
            this.usermap.put(teamPlayer.getJavaUUID(), (TeamPlayer)teamPlayer);
            return teamPlayer;
        }).orElseGet(() -> {
            String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
            if (name == null) {
                throw new IllegalArgumentException("Player " + String.valueOf(uuid) + " not found");
            }
            TeamPlayer teamPlayer = new TeamPlayer(uuid, name, false, null, Preferences.getDefaults());
            this.plugin.getDatabase().createPlayer(teamPlayer);
            this.usermap.put(uuid, teamPlayer);
            return teamPlayer;
        }));
    }

    public CompletableFuture<TeamPlayer> getBedrockPlayer(Player player) {
        FloodgatePlayer floodgatePlayer = this.plugin.getFloodgateApi().getPlayer(player.getUniqueId());
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getPlayer(floodgatePlayer.getJavaUniqueId()).map(teamPlayer -> this.usermap.put(teamPlayer.getJavaUUID(), (TeamPlayer)teamPlayer)).orElseGet(() -> {
            UUID bedrockPlayerUUID = floodgatePlayer.getJavaUniqueId();
            String lastPlayerName = floodgatePlayer.getUsername();
            TeamPlayer teamPlayer = new TeamPlayer(floodgatePlayer.getJavaUniqueId(), lastPlayerName, true, floodgatePlayer.getCorrectUniqueId().toString(), null);
            this.plugin.getDatabase().createPlayer(teamPlayer);
            return this.usermap.put(bedrockPlayerUUID, teamPlayer);
        }));
    }

    public boolean hasPlayerNameChanged(Player player) {
        for (TeamPlayer teamPlayer : this.usermap.values()) {
            if (player.getName().equals(teamPlayer.getLastPlayerName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasBedrockPlayerJavaUUIDChanged(Player player) {
        UUID uuid = player.getUniqueId();
        for (TeamPlayer teamPlayer : this.usermap.values()) {
            FloodgatePlayer floodgatePlayer;
            if (!this.plugin.getSettings().FloodGateHook() || this.plugin.getFloodgateApi() == null || (floodgatePlayer = this.plugin.getFloodgateApi().getPlayer(uuid)).getJavaUniqueId().toString().equals(teamPlayer.getBedrockUUID())) continue;
            return true;
        }
        return false;
    }

    public void updatePlayerName(Player player) {
        UUID uuid = player.getUniqueId();
        String newPlayerName = player.getName();
        TeamPlayer teamPlayer = this.usermap.get(uuid);
        teamPlayer.setLastPlayerName(newPlayerName);
        this.plugin.runAsync(task -> this.plugin.getDatabase().updatePlayer(teamPlayer));
        this.usermap.replace(uuid, teamPlayer);
    }

    public void updatePlayer(TeamPlayer teamPlayer) {
        this.plugin.runAsync(task -> this.plugin.getDatabase().updatePlayer(teamPlayer));
        this.usermap.replace(teamPlayer.getJavaUUID(), teamPlayer);
    }

    public void updateBedrockPlayerJavaUUID(Player player) {
        UUID uuid = player.getUniqueId();
        TeamPlayer teamPlayer = this.usermap.get(uuid);
        if (this.plugin.getSettings().FloodGateHook() && this.plugin.getFloodgateApi() != null) {
            FloodgatePlayer floodgatePlayer = this.plugin.getFloodgateApi().getPlayer(uuid);
            teamPlayer.setJavaUUID(floodgatePlayer.getJavaUniqueId());
            this.plugin.runAsync(task -> this.plugin.getDatabase().updatePlayer(teamPlayer));
            this.usermap.replace(uuid, teamPlayer);
        }
    }

    public boolean toggleChatSpy(Player player) {
        UUID uuid = player.getUniqueId();
        TeamPlayer teamPlayer = this.usermap.get(uuid);
        if (teamPlayer.getPreferences().isTeamChatSpying()) {
            teamPlayer.getPreferences().setTeamChatSpying(false);
            this.usermap.replace(uuid, teamPlayer);
            this.plugin.runAsync(task -> this.plugin.getDatabase().updatePlayer(teamPlayer));
            return false;
        }
        teamPlayer.getPreferences().setTeamChatSpying(true);
        this.usermap.replace(uuid, teamPlayer);
        this.plugin.runAsync(task -> this.plugin.getDatabase().updatePlayer(teamPlayer));
        return true;
    }

    public Set<UUID> getRawUsermapList() {
        return this.usermap.keySet();
    }

    public Map<UUID, TeamPlayer> getUsermap() {
        return this.usermap;
    }

    private void fireClanChatSpyToggledEvent(Player player, TeamPlayer teamPlayer, boolean chatSpyToggledState) {
        TeamChatSpyToggledEvent teamChatSpyToggledEvent = new TeamChatSpyToggledEvent(player, teamPlayer, chatSpyToggledState);
        Bukkit.getPluginManager().callEvent((Event)teamChatSpyToggledEvent);
    }

    @Generated
    public Map<String, List<User>> getGlobalUserList() {
        return this.globalUserList;
    }

    @Generated
    public ConcurrentMap<UUID, Player> getOnlineUserMap() {
        return this.onlineUserMap;
    }

    @Generated
    public ConcurrentMap<UUID, Boolean> getChatPlayers() {
        return this.chatPlayers;
    }
}

