/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.chat;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandPermission;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Syntax;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.network.Broker;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.network.Payload;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

@CommandAlias(value="ac|allychat|achat")
public class TeamAllyChatCommand
extends BaseCommand {
    private final FileConfiguration messagesConfig;
    private final Logger logger;
    private final UltimateTeams plugin;

    public TeamAllyChatCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
        this.logger = plugin.getLogger();
    }

    @Default
    @CommandCompletion(value="<message>")
    @Syntax(value="/allychat <message>")
    @CommandPermission(value="ultimateteams.allychat")
    public void onCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.logger.warning(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamAllyChatEnabled()) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        if (args.length < 1) {
            player.sendMessage(Utils.Color("&6UltimateTeams team chat usage:&3\n/allychat <message>"));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            Map<Team, Team.Relation> relations = team.getRelations(this.plugin);
            Set<Team> allies = relations.entrySet().stream().filter(entry -> entry.getValue() == Team.Relation.ALLY).map(Map.Entry::getKey).filter(otherTeam -> team.areRelationsBilateral((Team)otherTeam, Team.Relation.ALLY)).collect(Collectors.toSet());
            String chatSpyPrefix = this.plugin.getSettings().getTeamChatSpyPrefix();
            StringBuilder messageString = new StringBuilder();
            messageString.append(this.plugin.getSettings().getTeamAllyChatPrefix()).append(" ");
            messageString.append("&d").append(player.getName()).append(":&r").append(" ");
            for (String arg : args) {
                messageString.append(arg).append(" ");
            }
            String msg = messageString.toString().replace("%TEAM%", team.getName()).replace("%PLAYER%", player.getName());
            team.sendTeamMessage(Utils.Color(msg));
            allies.forEach(alliedTeam -> alliedTeam.sendTeamMessage(Utils.Color(msg)));
            if (this.plugin.getSettings().teamChatSpyEnabled()) {
                Bukkit.broadcast((String)Utils.Color(chatSpyPrefix + " " + msg), (String)"ultimateteams.chat.spy");
            }
            this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_ALLY_CHAT_MESSAGE).payload(Payload.string(msg)).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, player));
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }
}

