/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamInfoSubCommand {
    FileConfiguration messagesConfig;
    private static final String TEAM_PLACEHOLDER = "%TEAM%";
    private static final String OWNER = "%OWNER%";
    private static final String TEAM_MEMBER = "%MEMBER%";
    private static final String ALLY_TEAM = "%ALLYTEAM%";
    private static final String ENEMY_TEAM = "%ENEMYTEAM%";
    private final UltimateTeams plugin;

    public TeamInfoSubCommand(@NotNull UltimateTeams plugin) {
        this.messagesConfig = UltimateTeams.getPlugin().msgFileManager.getMessagesConfig();
        this.plugin = plugin;
    }

    public void teamInfoSubCommand(CommandSender sender, @Nullable String teamName) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (teamName != null) {
                this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> player.sendMessage(Utils.Color(this.getInfo((Team)team))), () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("team-not-found"))));
                return;
            }
            this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> player.sendMessage(Utils.Color(this.getInfo((Team)team))), () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
        } else {
            this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> sender.sendMessage(Utils.Color(this.getInfo((Team)team))), () -> sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-not-found"))));
        }
    }

    private String getInfo(@NotNull Team team) {
        String offlinePlayer;
        Player teamPlayer;
        Map<Team, Team.Relation> relations = team.getRelations(this.plugin);
        Map<Team, Team.Relation> allies = relations.entrySet().stream().filter(entry -> entry.getValue() == Team.Relation.ALLY).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Team, Team.Relation> enemies = relations.entrySet().stream().filter(entry -> entry.getValue() == Team.Relation.ENEMY).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set teamMembers = team.getMembers().entrySet().stream().filter(entry -> (Integer)entry.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set teamManagers = team.getMembers().entrySet().stream().filter(entry -> (Integer)entry.getValue() == 2).map(Map.Entry::getKey).collect(Collectors.toSet());
        StringBuilder teamInfo = new StringBuilder(Utils.Color(this.messagesConfig.getString("team-info-header")).replace(TEAM_PLACEHOLDER, Utils.Color(team.getName())).replace("%TEAMPREFIX%", Utils.Color(team.getPrefix() != null ? team.getPrefix() : "")));
        Player teamOwner = Bukkit.getPlayer((UUID)team.getOwner());
        if (teamOwner != null) {
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-owner-online")).replace(OWNER, teamOwner.getName()));
        } else {
            String offlineOwner = Bukkit.getOfflinePlayer((UUID)team.getOwner()).getName();
            offlineOwner = offlineOwner != null ? offlineOwner : "player not found";
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-owner-offline")).replace(OWNER, offlineOwner));
        }
        if (!teamMembers.isEmpty()) {
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-members-header").replace("%NUMBER%", Utils.Color(String.valueOf(teamMembers.size())))));
            for (UUID teamMember : teamMembers) {
                teamPlayer = Bukkit.getPlayer((UUID)teamMember);
                if (teamPlayer != null) {
                    teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-members-online") + "\n").replace(TEAM_MEMBER, teamPlayer.getName()));
                    continue;
                }
                offlinePlayer = Bukkit.getOfflinePlayer((UUID)teamMember).getName();
                teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-members-offline") + "\n").replace(TEAM_MEMBER, offlinePlayer != null ? offlinePlayer : "player not found"));
            }
        }
        if (!teamManagers.isEmpty()) {
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-managers-header").replace("%NUMBER%", Utils.Color(String.valueOf(teamManagers.size())))));
            for (UUID teamMember : teamManagers) {
                teamPlayer = Bukkit.getPlayer((UUID)teamMember);
                if (teamPlayer != null) {
                    teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-members-online") + "\n").replace(TEAM_MEMBER, teamPlayer.getName()));
                    continue;
                }
                offlinePlayer = Bukkit.getOfflinePlayer((UUID)teamMember).getName();
                teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-members-offline") + "\n").replace(TEAM_MEMBER, offlinePlayer != null ? offlinePlayer : "player not found"));
            }
        }
        if (!allies.isEmpty()) {
            teamInfo.append(" ");
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-allies-header")));
            allies.keySet().forEach(t -> teamInfo.append(Utils.Color(this.messagesConfig.getString("team-ally-members").replace(ALLY_TEAM, t.getName()))));
        }
        if (!enemies.isEmpty()) {
            teamInfo.append(" ");
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-enemies-header")));
            enemies.keySet().forEach(t -> teamInfo.append(Utils.Color(this.messagesConfig.getString("team-enemy-members").replace(ENEMY_TEAM, t.getName()))));
        }
        teamInfo.append(" ");
        if (team.isFriendlyFire()) {
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-pvp-status-enabled")));
        } else {
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-pvp-status-disabled")));
        }
        if (this.plugin.getTeamStorageUtil().isHomeSet(team)) {
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-home-set-true")));
        } else {
            teamInfo.append(Utils.Color(this.messagesConfig.getString("team-home-set-false")));
        }
        teamInfo.append(" ");
        teamInfo.append(Utils.Color(this.messagesConfig.getString("team-info-footer")));
        return teamInfo.toString();
    }
}

