/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.home;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamHomeDeleteEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TeamDelHomeSubCommand {
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public TeamDelHomeSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    public void deleteTeamHomeSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamHomeEnabled()) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.HOME))) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                return;
            }
            if (this.plugin.getTeamStorageUtil().isHomeSet((Team)team)) {
                this.fireTeamHomeDeleteEvent(player, (Team)team);
                this.plugin.getTeamStorageUtil().deleteHome(player, (Team)team);
                player.sendMessage(Utils.Color(this.messagesConfig.getString("successfully-deleted-team-home")));
            } else {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-no-home-set")));
            }
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("team-must-be-owner"))));
    }

    private void fireTeamHomeDeleteEvent(Player player, Team team) {
        TeamHomeDeleteEvent teamHomeDeleteEvent = new TeamHomeDeleteEvent(player, team);
        Bukkit.getPluginManager().callEvent((Event)teamHomeDeleteEvent);
    }
}

