/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamLeaveSubCommand {
    FileConfiguration messagesConfig;
    private static final String Team_PLACEHOLDER = "%TEAM%";
    private final UltimateTeams plugin;

    public TeamLeaveSubCommand(@NotNull UltimateTeams plugin) {
        this.messagesConfig = UltimateTeams.getPlugin().msgFileManager.getMessagesConfig();
        this.plugin = plugin;
    }

    public void teamLeaveSubCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-team-owner")));
                return;
            }
            this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
                team.removeMember(player.getUniqueId());
                this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAcceptAsync(teamPlayer -> {
                    if (teamPlayer.getPreferences().isTeamChatTalking()) {
                        teamPlayer.getPreferences().setTeamChatTalking(false);
                        this.plugin.getDatabase().updatePlayer((TeamPlayer)teamPlayer);
                    }
                });
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
                String leaveMessage = Utils.Color(this.messagesConfig.getString("team-leave-successful")).replace(Team_PLACEHOLDER, Utils.Color(team.getName()));
                player.sendMessage(leaveMessage);
                if (this.plugin.getSettings().teamLeftAnnounce()) {
                    team.sendTeamMessage(Utils.Color(this.messagesConfig.getString("team-left-broadcast-chat").replace("%PLAYER%", player.getName()).replace(Team_PLACEHOLDER, Utils.Color(team.getName()))));
                }
            }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("team-leave-failed"))));
        }
    }
}

