/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamPvpSubCommand {
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public TeamPvpSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    public void teamPvpSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().isPvpCommandEnabled()) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.PVP))) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                return;
            }
            if (team.isFriendlyFireAllowed()) {
                team.setFriendlyFire(false);
                player.sendMessage(Utils.Color(this.messagesConfig.getString("disabled-friendly-fire")));
            } else {
                team.setFriendlyFire(true);
                player.sendMessage(Utils.Color(this.messagesConfig.getString("enabled-friendly-fire")));
            }
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-not-in-team"))));
    }
}

