/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Values;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamTransferOwnerSubCommand {
    FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public TeamTransferOwnerSubCommand(@NotNull UltimateTeams plugin) {
        this.messagesConfig = UltimateTeams.getPlugin().msgFileManager.getMessagesConfig();
        this.plugin = plugin;
    }

    public void transferTeamOwnerSubCommand(CommandSender sender, @Values(value="teamPlayers") String memberName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        String PLAYER_PLACEHOLDER = "%PLAYER%";
        OfflinePlayer newTeamOwner = Bukkit.getOfflinePlayer((String)memberName);
        if (!this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-must-be-owner")));
            return;
        }
        if (newTeamOwner.getName() == null) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("player-not-found")));
            return;
        }
        if (player.getUniqueId().equals(newTeamOwner.getUniqueId())) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-ownership-transfer-failed-cannot-transfer-to-self").replace("%PLAYER%", player.getName())));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByOwner(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!team.getMembers().containsKey(newTeamOwner.getUniqueId())) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("team-ownership-transfer-failure-not-same-team")));
                return;
            }
            this.plugin.getTeamStorageUtil().transferTeamOwner((Team)team, newTeamOwner.getUniqueId());
            String OLD_OWNER_PLACEHOLDER = "%OLDOWNER%";
            String NEW_Team_NAME = "%Team%";
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-ownership-transfer-successful").replace("%PLAYER%", newTeamOwner.getName())));
            if (newTeamOwner.isOnline() && newTeamOwner.getPlayer() != null) {
                newTeamOwner.getPlayer().sendMessage(Utils.Color(this.messagesConfig.getString("team-ownership-transfer-new-owner").replace(OLD_OWNER_PLACEHOLDER, player.getName()).replace(NEW_Team_NAME, team.getName())));
            }
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }
}

