/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.warps;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamWarpSubCommand {
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;
    private static final ConcurrentHashMap<UUID, Long> warpCoolDownTimer = new ConcurrentHashMap();
    private static final String TIME_LEFT = "%TIMELEFT%";

    public TeamWarpSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    public void WarpCommand(CommandSender sender, String name) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamWarpEnabled()) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (this.plugin.getSettings().teamWarpCooldownEnabled()) {
                if (!player.hasPermission("ultimateteams.bypass.warpcooldown") && warpCoolDownTimer.containsKey(player.getUniqueId())) {
                    if (warpCoolDownTimer.get(player.getUniqueId()) > System.currentTimeMillis()) {
                        long timeLeft = (warpCoolDownTimer.get(player.getUniqueId()) - System.currentTimeMillis()) / 1000L;
                        player.sendMessage(Utils.Color(this.messagesConfig.getString("home-cool-down-timer-wait").replaceAll(TIME_LEFT, Long.toString(timeLeft))));
                    } else {
                        warpCoolDownTimer.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.plugin.getSettings().getTeamHomeCooldownValue() * 1000L);
                        this.tpWarp(player, (Team)team, name);
                    }
                } else {
                    this.tpWarp(player, (Team)team, name);
                    warpCoolDownTimer.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.plugin.getSettings().getTeamHomeCooldownValue() * 1000L);
                }
                return;
            }
            this.tpWarp(player, (Team)team, name);
            player.sendMessage(Utils.Color(this.messagesConfig.getString("successfully-teleported-to-home")));
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("failed-not-in-team"))));
    }

    private void tpWarp(Player player, Team team, String name) {
        team.getTeamWarp(name).ifPresentOrElse(warp -> {
            this.plugin.getUtils().teleportPlayer(player, warp.getLocation(), warp.getServer(), Utils.TeleportType.WARP, name);
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-warp-teleported-successful").replaceAll("%WARP_NAME%", warp.getName())));
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("team-warp-not-found"))));
    }
}

