/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.database;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.intellij.lang.annotations.Language;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.Player;

public abstract class Database {
    protected final UltimateTeams plugin;
    private boolean loaded;

    protected Database(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    @NotNull
    protected final String[] getSchema(@NotNull String schemaFileName) throws IOException {
        return this.format(new String(Objects.requireNonNull(this.plugin.getResource(schemaFileName)).readAllBytes(), StandardCharsets.UTF_8)).split(";");
    }

    @NotNull
    protected final String format(@NotNull @Language(value="SQL") String statement) {
        return statement.replaceAll("%team_table%", this.plugin.getSettings().getTableName(Table.TEAM_DATA)).replaceAll("%user_table%", this.plugin.getSettings().getTableName(Table.USER_DATA));
    }

    public abstract void initialize();

    public abstract List<Team> getAllTeams();

    public abstract void createPlayer(@NotNull TeamPlayer var1);

    public abstract void updatePlayer(@NotNull TeamPlayer var1);

    public abstract Optional<TeamPlayer> getPlayer(@NotNull UUID var1);

    public abstract Team createTeam(@NotNull String var1, @NotNull Player var2);

    public abstract Team createTeam(@NotNull Team var1);

    public abstract Optional<Team> getTeam(@NotNull Integer var1);

    public abstract void updateTeam(@NotNull Team var1);

    public abstract void deleteTeam(@NotNull Integer var1);

    public abstract void deleteAllTeams();

    public abstract void deleteAllUsers();

    public abstract void close();

    public boolean hasLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public static enum Table {
        USER_DATA("ultimateteams_users"),
        TEAM_DATA("ultimateteams_teams");

        @NotNull
        private final String defaultName;

        private Table(String defaultName) {
            this.defaultName = defaultName;
        }

        @NotNull
        public static Table match(@NotNull String placeholder) throws IllegalArgumentException {
            return Table.valueOf(placeholder.toUpperCase());
        }

        @NotNull
        public String getDefaultName() {
            return this.defaultName;
        }
    }

    public static enum Type {
        MYSQL("MySQL", "mysql"),
        MARIADB("MariaDB", "mariadb"),
        SQLITE("SQLite", "sqlite"),
        H2("H2", "h2"),
        POSTGRESQL("PostgreSQL", "postgresql");

        private final String displayName;
        private final String protocol;

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        private Type(String displayName, String protocol) {
            this.displayName = displayName;
            this.protocol = protocol;
        }
    }
}

