/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.gui;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiElementGroup;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.GuiPageElement;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.InventoryGui;
import dev.xf3d3.ultimateteams.libraries.inventorygui.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class TeamList {
    private final UltimateTeams plugin;
    private final Player player;

    public TeamList(@NotNull UltimateTeams plugin, @NotNull Player player) {
        this.plugin = plugin;
        this.player = player;
        this.open();
    }

    private void open() {
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, (InventoryHolder)this.player, Utils.Color(this.plugin.getTeamsGui().getTeamsListGuiName()), this.plugin.getTeamsGui().getTeamsListguiSetup().toArray(new String[0]), new GuiElement[0]);
        gui.addElement(new GuiPageElement('f', new ItemStack(this.plugin.getTeamsGui().getPreviousPageMaterial()), GuiPageElement.PageAction.PREVIOUS, this.plugin.getTeamsGui().getPreviousPage()));
        gui.addElement(new GuiPageElement('n', new ItemStack(this.plugin.getTeamsGui().getNextPageMaterial()), GuiPageElement.PageAction.NEXT, this.plugin.getTeamsGui().getNextPage()));
        gui.addElement(new StaticGuiElement('c', new ItemStack(this.plugin.getTeamsGui().getCloseButtonMaterial()), 1, click -> {
            click.getGui().close();
            return true;
        }, this.plugin.getTeamsGui().getCloseButtonName()));
        GuiElementGroup group = new GuiElementGroup('g', new GuiElement[0]);
        for (Team team : this.plugin.getTeamStorageUtil().getTeams()) {
            OfflinePlayer teamOwnerPlayer = Bukkit.getOfflinePlayer((UUID)team.getOwner());
            group.addElement(new StaticGuiElement('e', TeamList.createPlayerSkull(teamOwnerPlayer), TeamList.getTeamInfo(this.plugin, team).toArray(new String[0])));
        }
        gui.addElement(group);
        gui.show((HumanEntity)this.player);
    }

    public static ArrayList<String> getTeamInfo(UltimateTeams plugin, Team team) {
        OfflinePlayer teamOwnerPlayer = Bukkit.getOfflinePlayer((UUID)team.getOwner());
        Map<Team, Team.Relation> relations = team.getRelations(plugin);
        Map<Team, Team.Relation> allies = relations.entrySet().stream().filter(entry -> entry.getValue() == Team.Relation.ALLY).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Team, Team.Relation> enemies = relations.entrySet().stream().filter(entry -> entry.getValue() == Team.Relation.ENEMY).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set teamMembers = team.getMembers().entrySet().stream().filter(entry -> (Integer)entry.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set teamManagers = team.getMembers().entrySet().stream().filter(entry -> (Integer)entry.getValue() == 2).map(Map.Entry::getKey).collect(Collectors.toSet());
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("header")));
        lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("team-name") + Utils.Color(team.getName())));
        if (teamOwnerPlayer.isOnline()) {
            lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("owner-online") + teamOwnerPlayer.getName()));
        } else {
            lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("owner-offline") + teamOwnerPlayer.getName()));
        }
        if (!team.getMembers().isEmpty()) {
            String offlinePlayer;
            for (UUID teamMember : teamMembers) {
                offlinePlayer = Bukkit.getOfflinePlayer((UUID)teamMember).getName();
                lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("members")));
                lore.add((String)(offlinePlayer != null ? "&r" + offlinePlayer : "&rplayer not found"));
            }
            for (UUID teamMember : teamManagers) {
                offlinePlayer = Bukkit.getOfflinePlayer((UUID)teamMember).getName();
                lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("managers")));
                lore.add((String)(offlinePlayer != null ? "&r" + offlinePlayer : "&rplayer not found"));
            }
        }
        if (!allies.isEmpty()) {
            lore.add(" ");
            lore.add(Utils.Color(Utils.Color(plugin.getTeamsGui().getLoreMap().get("allies"))));
            allies.keySet().forEach(t -> lore.add("&r" + t.getName()));
        }
        if (!enemies.isEmpty()) {
            lore.add(" ");
            lore.add(Utils.Color(Utils.Color(plugin.getTeamsGui().getLoreMap().get("enemies"))));
            enemies.keySet().forEach(t -> lore.add("&r" + t.getName()));
        }
        lore.add(" ");
        lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("prefix") + (team.getPrefix() != null ? team.getPrefix() : "")));
        if (team.isFriendlyFire()) {
            lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("pvp") + " &cTRUE"));
        } else {
            lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("pvp") + " &cFALSE"));
        }
        if (plugin.getTeamStorageUtil().isHomeSet(team)) {
            lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("home") + " &cTRUE"));
        } else {
            lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("home") + " &cFALSE"));
        }
        lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("footer-1")));
        lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("action")));
        lore.add(Utils.Color(plugin.getTeamsGui().getLoreMap().get("footer-2")));
        return lore;
    }

    public static ItemStack createPlayerSkull(OfflinePlayer owner) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        if (skullMeta != null) {
            skullMeta.setOwningPlayer(owner);
            skull.setItemMeta((ItemMeta)skullMeta);
        }
        return skull;
    }
}

