/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.hooks;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Map;
import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class PapiExpansion
extends PlaceholderExpansion {
    private final UltimateTeams plugin;

    public PapiExpansion(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "UltimateTeams";
    }

    @NotNull
    public String getAuthor() {
        return "xF3d3";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getPluginVersion().toStringWithoutMetadata();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        Optional<Team> optionalTeam = this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId());
        if (params.equalsIgnoreCase("teamName")) {
            return Utils.Color(optionalTeam.map(Team::getName).orElse(this.plugin.getSettings().getNotInTeamPlaceholder()));
        }
        if (params.equalsIgnoreCase("teamPrefix")) {
            String openBracket = this.plugin.getSettings().getPrefixBracketsOpening();
            String closeBracket = this.plugin.getSettings().getPrefixBracketsClosing();
            return Utils.Color(optionalTeam.map(team -> {
                String prefix = team.getPrefix();
                if (prefix == null || prefix.isEmpty()) {
                    return "";
                }
                return this.plugin.getSettings().addPrefixBrackets() ? openBracket + prefix + closeBracket : prefix + "&r" + (this.plugin.getSettings().addSpaceAfterPrefix() ? " " : "");
            }).orElse("") + (optionalTeam.isPresent() ? "" : this.plugin.getSettings().getNotInTeamPlaceholder()));
        }
        if (params.equalsIgnoreCase("friendlyFire")) {
            return Utils.Color(optionalTeam.map(Team::isFriendlyFire).map(String::valueOf).orElse(this.plugin.getSettings().getNotInTeamPlaceholder()));
        }
        if (params.equalsIgnoreCase("teamHomeSet")) {
            return Utils.Color(optionalTeam.map(this.plugin.getTeamStorageUtil()::isHomeSet).map(String::valueOf).orElse(this.plugin.getSettings().getNotInTeamPlaceholder()));
        }
        if (params.equalsIgnoreCase("teamMembersSize")) {
            return Utils.Color(optionalTeam.map(Team::getMembers).map(Map::size).map(String::valueOf).orElse(this.plugin.getSettings().getNotInTeamPlaceholder()));
        }
        if (params.equalsIgnoreCase("teamAllySize")) {
            return Utils.Color(optionalTeam.map(team -> team.getRelations(this.plugin).values().stream()).map(relationStream -> relationStream.filter(relation -> relation == Team.Relation.ALLY).count()).map(String::valueOf).orElse(this.plugin.getSettings().getNotInTeamPlaceholder()));
        }
        if (params.equalsIgnoreCase("teamEnemySize")) {
            return Utils.Color(optionalTeam.map(team -> team.getRelations(this.plugin).values().stream()).map(relationStream -> relationStream.filter(relation -> relation == Team.Relation.ENEMY).count()).map(String::valueOf).orElse(this.plugin.getSettings().getNotInTeamPlaceholder()));
        }
        if (params.equalsIgnoreCase("isInTeam")) {
            return String.valueOf(optionalTeam.isPresent());
        }
        return null;
    }
}

