/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.libraries.gson;

import dev.xf3d3.ultimateteams.libraries.gson.JsonElement;
import dev.xf3d3.ultimateteams.libraries.gson.JsonIOException;
import dev.xf3d3.ultimateteams.libraries.gson.JsonParseException;
import dev.xf3d3.ultimateteams.libraries.gson.JsonSyntaxException;
import dev.xf3d3.ultimateteams.libraries.gson.Strictness;
import dev.xf3d3.ultimateteams.libraries.gson.internal.Streams;
import dev.xf3d3.ultimateteams.libraries.gson.stream.JsonReader;
import dev.xf3d3.ultimateteams.libraries.gson.stream.JsonToken;
import dev.xf3d3.ultimateteams.libraries.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String json) {
        this(new StringReader(json));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonReader(reader);
        this.parser.setStrictness(Strictness.LENIENT);
        this.lock = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException e) {
                throw new JsonSyntaxException(e);
            }
            catch (IOException e) {
                throw new JsonIOException(e);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

