/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.libraries.william278.desertwell.about;

import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.libraries.william278.desertwell.util.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class AboutMenu {
    private final Component title;
    private final Component description;
    private final Version version;
    private final TextColor themeColor;
    private final TextColor secondaryColor;
    private final Map<String, List<Credit>> attributions;
    private final List<Link> buttons;

    private AboutMenu(@NotNull Component title, @Nullable Component description, @Nullable Version version, @NotNull TextColor themeColor, @NotNull TextColor secondaryColor, @NotNull Map<String, List<Credit>> attributions, @NotNull List<Link> buttons) {
        this.title = title;
        this.description = description;
        this.version = version;
        this.themeColor = themeColor;
        this.secondaryColor = secondaryColor;
        this.attributions = attributions;
        this.buttons = buttons;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public TextComponent toComponent() {
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.newline())).append(this.title.colorIfAbsent(this.themeColor).decorate(TextDecoration.BOLD));
        if (this.version != null) {
            builder.append(Component.text((String)(" | v" + this.version)).color(this.themeColor));
        }
        if (this.description != null) {
            ((TextComponent.Builder)builder.append((Component)Component.newline())).append(this.description.colorIfAbsent(this.secondaryColor));
        }
        if (!this.attributions.isEmpty()) {
            builder.append((Component)Component.newline());
        }
        for (Map.Entry<String, List<Credit>> entry : this.attributions.entrySet()) {
            ((TextComponent.Builder)builder.append((Component)Component.newline())).append(Component.text((String)("\u2022 " + entry.getKey() + ": ")).color((TextColor)NamedTextColor.WHITE));
            AtomicInteger credits = new AtomicInteger();
            entry.getValue().stream().map(Credit::toComponent).forEach(name -> {
                if (credits.getAndIncrement() > 0) {
                    builder.append((Component)Component.text((String)", "));
                }
                ((TextComponent.Builder)builder.append(name)).color(this.secondaryColor);
            });
        }
        if (!this.buttons.isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append((Component)Component.newline())).append(Component.text((String)"Links: ").color(this.secondaryColor));
            AtomicInteger links = new AtomicInteger();
            this.buttons.stream().map(Link::toComponent).forEach(link -> {
                if (links.getAndIncrement() > 0) {
                    builder.append((Component)Component.text((String)"   "));
                }
                builder.append(link);
            });
        }
        return (TextComponent)builder.build();
    }

    public static class Credit {
        private final String name;
        @Nullable
        private String description;
        @Nullable
        private String url;
        private TextColor color = TextColor.color((int)0xAAAAAA);

        private Credit(@NotNull String name) {
            this.name = name;
        }

        @NotNull
        public static Credit of(@NotNull String name) {
            return new Credit(name);
        }

        @NotNull
        public Credit description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @NotNull
        public Credit url(@Nullable String url) {
            this.url = url;
            return this;
        }

        @NotNull
        public Credit color(@NotNull TextColor color) {
            this.color = color;
            return this;
        }

        @NotNull
        public Component toComponent() {
            TextComponent.Builder builder = Component.text().content(this.name);
            if (this.description != null) {
                builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)this.description, (TextColor)this.color)));
            }
            if (this.url != null) {
                builder.clickEvent(ClickEvent.openUrl((String)this.url));
            }
            return ((TextComponent.Builder)builder.color(this.color)).build();
        }
    }

    public static class Link {
        private String text = "Link";
        private TextColor color = TextColor.color((int)64410);
        private final String url;
        private String icon;

        private Link(@NotNull String url) {
            this.url = url;
        }

        public static Link of(@NotNull String url) {
            return new Link(url);
        }

        public Link text(@NotNull String text) {
            this.text = text;
            return this;
        }

        public Link icon(@NotNull String icon) {
            this.icon = icon;
            return this;
        }

        public Link color(@NotNull TextColor color) {
            this.color = color;
            return this;
        }

        @NotNull
        public Component toComponent() {
            return Component.text((String)("[" + (this.icon == null ? "" : this.icon) + " " + this.text + "]"), (TextColor)this.color).clickEvent(ClickEvent.openUrl((String)this.url));
        }
    }

    public static class Builder {
        private Component title;
        private Component description;
        private Version version;
        private TextColor themeColor = TextColor.color((int)64410);
        private TextColor secondaryColor = TextColor.color((int)0xAAAAAA);
        private final Map<String, List<Credit>> attributions = new LinkedHashMap<String, List<Credit>>();
        private final List<Link> buttons = new ArrayList<Link>();

        private Builder() {
        }

        @NotNull
        public Builder title(@NotNull Component title) {
            this.title = title;
            return this;
        }

        @NotNull
        public Builder description(@Nullable Component description) {
            this.description = description;
            return this;
        }

        @NotNull
        public Builder themeColor(@NotNull TextColor themeColor) {
            this.themeColor = themeColor;
            return this;
        }

        @NotNull
        public Builder secondaryColor(@NotNull TextColor secondaryColor) {
            this.secondaryColor = secondaryColor;
            return this;
        }

        @NotNull
        public Builder version(@NotNull Version version) {
            this.version = version;
            return this;
        }

        @NotNull
        public Builder credits(@NotNull String category, Credit ... credits) {
            ArrayList<Credit> creditList = new ArrayList<Credit>(Arrays.asList(credits));
            this.attributions.putIfAbsent(category, new ArrayList());
            this.attributions.get(category).addAll(creditList);
            return this;
        }

        @NotNull
        public Builder buttons(Link ... links) {
            this.buttons.addAll(Arrays.asList(links));
            return this;
        }

        @NotNull
        public AboutMenu build() {
            if (this.title == null) {
                throw new IllegalStateException("Title must be set");
            }
            return new AboutMenu(this.title, this.description, this.version, this.themeColor, this.secondaryColor, this.attributions, this.buttons);
        }
    }
}

