/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.migrator.legacyModels;

import dev.xf3d3.ultimateteams.libraries.gson.annotations.Expose;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.migrator.legacyModels.LegacyTeamWarp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class LegacyTeam {
    public int id;
    @Expose
    private String teamFinalOwner;
    @Expose
    private String teamFinalName;
    @Expose
    private String teamPrefix;
    @Expose
    private ConcurrentHashMap<String, LegacyTeamWarp> teamWarps;
    @Expose
    private ArrayList<String> teamMembers;
    @Expose
    private ArrayList<String> teamAllies;
    @Expose
    private ArrayList<String> teamEnemies;
    @Expose
    private boolean friendlyFire;
    @Expose
    private String teamHomeWorld;
    @Expose
    @Nullable
    private Double teamHomeX;
    @Expose
    @Nullable
    private Double teamHomeY;
    @Expose
    @Nullable
    private Double teamHomeZ;
    @Expose
    @Nullable
    private Float teamHomeYaw;
    @Expose
    @Nullable
    private Float teamHomePitch;

    public String getTeamOwner() {
        return this.teamFinalOwner;
    }

    public String getTeamFinalName() {
        return this.teamFinalName;
    }

    public String getTeamPrefix() {
        return this.teamPrefix;
    }

    public Collection<LegacyTeamWarp> getTeamWarps() {
        return this.teamWarps.values();
    }

    public LegacyTeamWarp getTeamWarp(@NotNull String name) {
        return this.teamWarps.get(name);
    }

    public ArrayList<String> getTeamMembers() {
        return this.teamMembers;
    }

    public ArrayList<String> getTeamAllies() {
        return this.teamAllies;
    }

    public ArrayList<String> getTeamEnemies() {
        return this.teamEnemies;
    }

    public boolean isFriendlyFireAllowed() {
        return this.friendlyFire;
    }

    @Nullable
    public String getTeamHomeWorld() {
        return this.teamHomeWorld;
    }

    public double getTeamHomeX() {
        return Objects.requireNonNullElseGet(this.teamHomeX, null);
    }

    public double getTeamHomeY() {
        return Objects.requireNonNullElseGet(this.teamHomeY, null);
    }

    public double getTeamHomeZ() {
        return Objects.requireNonNullElseGet(this.teamHomeZ, null);
    }

    public float getTeamHomeYaw() {
        return Objects.requireNonNullElseGet(this.teamHomeYaw, null).floatValue();
    }

    public float getTeamHomePitch() {
        return Objects.requireNonNullElseGet(this.teamHomePitch, null).floatValue();
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }
}

