/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.network;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.network.PluginMessageBroker;
import java.util.logging.Level;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.util.Pool;

public class RedisBroker
extends PluginMessageBroker {
    private Pool<Jedis> jedisPool;

    public RedisBroker(@NotNull UltimateTeams plugin) {
        super(plugin);
    }

    @Override
    public void initialize() throws RuntimeException {
        super.initialize();
        this.jedisPool = this.establishJedisPool();
        new Thread(this.getSubscriber(), "UltimateTeams_redis_subscriber").start();
        this.plugin.log(Level.INFO, "Initialized Redis connection pool", new Throwable[0]);
    }

    @NotNull
    private Pool<Jedis> establishJedisPool() {
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.plugin.getSettings().getRedisHost(), this.plugin.getSettings().getRedisPort(), 0, this.plugin.getSettings().getRedisPassword().isEmpty() ? null : this.plugin.getSettings().getRedisPassword(), this.plugin.getSettings().isRedisUseSSL());
        this.plugin.log(Level.INFO, "Using Redis pool", new Throwable[0]);
        return pool;
    }

    @NotNull
    private Runnable getSubscriber() {
        return () -> {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                jedis.subscribe(new JedisPubSub(){

                    public void onMessage(@NotNull String channel, @NotNull String encodedMessage) {
                        if (!channel.equals(RedisBroker.this.getSubChannelId())) {
                            return;
                        }
                        Message message = RedisBroker.this.plugin.getMessageFromJson(encodedMessage);
                        if (message.getTargetType() == Message.TargetType.PLAYER) {
                            Bukkit.getOnlinePlayers().stream().filter(player -> player.getName().equalsIgnoreCase(message.getTarget())).findFirst().ifPresent(receiver -> RedisBroker.this.handle((Player)receiver, message));
                            return;
                        }
                        RedisBroker.this.handle(RedisBroker.this.plugin.getUsersStorageUtil().getOnlineUsers().stream().findAny().orElse(null), message);
                    }
                }, new String[]{this.getSubChannelId()});
            }
        };
    }

    @Override
    protected void send(@NotNull Message message, @NotNull Player sender) {
        this.plugin.runAsync(task -> {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                jedis.publish(this.getSubChannelId(), this.plugin.getGson().toJson(message));
            }
        });
    }

    @Override
    public void close() {
        super.close();
        if (this.jedisPool != null) {
            this.jedisPool.close();
        }
    }
}

