/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.utils;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.folialib.impl.PlatformScheduler;
import dev.xf3d3.ultimateteams.libraries.folialib.wrapper.task.WrappedTask;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface TaskRunner {
    public static final UltimateTeams plugin = UltimateTeams.getPlugin();

    default public void runAsync(@NotNull Consumer<WrappedTask> runnable) {
        this.getScheduler().runAsync(runnable);
    }

    default public <T> CompletableFuture<T> supplyAsync(@NotNull Supplier<T> supplier) {
        CompletableFuture future = new CompletableFuture();
        this.runAsync(task -> {
            try {
                future.complete(supplier.get());
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    default public void runLater(@NotNull Runnable runnable, long delay) {
        this.getScheduler().runLater(runnable, delay * 20L);
    }

    default public void runSync(@NotNull Consumer<WrappedTask> runnable) {
        this.getScheduler().runNextTick(runnable);
    }

    default public void runSyncDelayed(@NotNull Runnable runnable, long delay) {
        this.getScheduler().runLater(runnable, delay);
    }

    default public void runSyncRepeating(@NotNull Runnable runnable, long period) {
        this.getScheduler().runTimer(runnable, 0L, period);
    }

    @NotNull
    public PlatformScheduler getScheduler();

    @NotNull
    default public Duration getDurationTicks(long ticks) {
        return Duration.of(ticks * 50L, ChronoUnit.MILLIS);
    }
}

